/*
 * Decompiled with CFR 0.152.
 */
package com.adsdk.sdk.mraid;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.URLUtil;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.adsdk.sdk.mraid.MraidAbstractController;
import com.adsdk.sdk.mraid.MraidProperty;
import com.adsdk.sdk.mraid.MraidScreenSizeProperty;
import com.adsdk.sdk.mraid.MraidStateProperty;
import com.adsdk.sdk.mraid.MraidView;
import com.adsdk.sdk.mraid.MraidViewableProperty;
import com.adsdk.sdk.video.ResourceManager;
import java.util.ArrayList;

class MraidDisplayController
extends MraidAbstractController {
    private static final String LOGTAG = "MraidDisplayController";
    private static final long VIEWABILITY_TIMER_MILLIS = 3000L;
    private static final int CLOSE_BUTTON_SIZE_DP = 50;
    private MraidView.ViewState mViewState = MraidView.ViewState.HIDDEN;
    private final MraidView.ExpansionStyle mExpansionStyle;
    private final MraidView.NativeCloseButtonStyle mNativeCloseButtonStyle;
    private MraidView mTwoPartExpansionView;
    private FrameLayout mRootView;
    private boolean mIsViewable;
    private Runnable mCheckViewabilityTask = new Runnable(){

        @Override
        public void run() {
            boolean currentViewable = MraidDisplayController.this.checkViewable();
            if (MraidDisplayController.this.mIsViewable != currentViewable) {
                MraidDisplayController.this.mIsViewable = currentViewable;
                MraidDisplayController.this.getView().fireChangeEventForProperty(MraidViewableProperty.createWithViewable(MraidDisplayController.this.mIsViewable));
            }
            MraidDisplayController.this.mHandler.postDelayed((Runnable)this, 3000L);
        }
    };
    private Handler mHandler = new Handler();
    private final int mOriginalRequestedOrientation;
    private BroadcastReceiver mOrientationBroadcastReceiver = new BroadcastReceiver(){
        private int mLastRotation;

        public void onReceive(Context context, Intent intent) {
            int orientation;
            String action = intent.getAction();
            if (action.equals("android.intent.action.CONFIGURATION_CHANGED") && (orientation = MraidDisplayController.this.getDisplayRotation()) != this.mLastRotation) {
                this.mLastRotation = orientation;
                MraidDisplayController.this.onOrientationChanged(this.mLastRotation);
            }
        }
    };
    private ImageView mCloseButton;
    private boolean mAdWantsCustomCloseButton;
    protected float mDensity;
    protected int mScreenWidth = -1;
    protected int mScreenHeight = -1;
    private int mViewIndexInParent;
    FrameLayout mPlaceholderView;

    MraidDisplayController(MraidView view, MraidView.ExpansionStyle expStyle, MraidView.NativeCloseButtonStyle buttonStyle) {
        super(view);
        this.mExpansionStyle = expStyle;
        this.mNativeCloseButtonStyle = buttonStyle;
        Context context = this.getView().getContext();
        this.mOriginalRequestedOrientation = context instanceof Activity ? ((Activity)context).getRequestedOrientation() : -1;
        this.initialize();
    }

    private void initialize() {
        this.mViewState = MraidView.ViewState.LOADING;
        this.initializeScreenMetrics();
        this.initializeViewabilityTimer();
        this.getView().getContext().registerReceiver(this.mOrientationBroadcastReceiver, new IntentFilter("android.intent.action.CONFIGURATION_CHANGED"));
    }

    private void initializeScreenMetrics() {
        Context context = this.getView().getContext();
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(metrics);
        this.mDensity = metrics.density;
        int statusBarHeight = 0;
        int titleBarHeight = 0;
        if (context instanceof Activity) {
            Activity activity = (Activity)context;
            Window window = activity.getWindow();
            Rect rect = new Rect();
            window.getDecorView().getWindowVisibleDisplayFrame(rect);
            statusBarHeight = rect.top;
            int contentViewTop = window.findViewById(0x1020002).getTop();
            titleBarHeight = contentViewTop - statusBarHeight;
        }
        int widthPixels = metrics.widthPixels;
        int heightPixels = metrics.heightPixels - statusBarHeight - titleBarHeight;
        this.mScreenWidth = (int)((double)widthPixels * (160.0 / (double)metrics.densityDpi));
        this.mScreenHeight = (int)((double)heightPixels * (160.0 / (double)metrics.densityDpi));
    }

    private void initializeViewabilityTimer() {
        this.mHandler.removeCallbacks(this.mCheckViewabilityTask);
        this.mHandler.post(this.mCheckViewabilityTask);
    }

    private int getDisplayRotation() {
        WindowManager wm = (WindowManager)this.getView().getContext().getSystemService("window");
        return wm.getDefaultDisplay().getOrientation();
    }

    private void onOrientationChanged(int currentRotation) {
        this.initializeScreenMetrics();
        this.getView().fireChangeEventForProperty(MraidScreenSizeProperty.createWithSize(this.mScreenWidth, this.mScreenHeight));
    }

    public void destroy() {
        block2: {
            this.mHandler.removeCallbacks(this.mCheckViewabilityTask);
            try {
                this.getView().getContext().unregisterReceiver(this.mOrientationBroadcastReceiver);
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage().contains("Receiver not registered")) break block2;
                throw e;
            }
        }
    }

    protected void initializeJavaScriptState() {
        ArrayList<MraidProperty> properties = new ArrayList<MraidProperty>();
        properties.add(MraidScreenSizeProperty.createWithSize(this.mScreenWidth, this.mScreenHeight));
        properties.add(MraidViewableProperty.createWithViewable(this.mIsViewable));
        this.getView().fireChangeEventForProperties(properties);
        this.mViewState = MraidView.ViewState.DEFAULT;
        this.getView().fireChangeEventForProperty(MraidStateProperty.createWithViewState(this.mViewState));
    }

    protected boolean isExpanded() {
        return this.mViewState == MraidView.ViewState.EXPANDED;
    }

    protected void close() {
        if (this.mViewState == MraidView.ViewState.EXPANDED) {
            this.resetViewToDefaultState();
            this.setOrientationLockEnabled(false);
            this.mViewState = MraidView.ViewState.DEFAULT;
            this.getView().fireChangeEventForProperty(MraidStateProperty.createWithViewState(this.mViewState));
        } else if (this.mViewState == MraidView.ViewState.DEFAULT) {
            this.getView().setVisibility(4);
            this.mViewState = MraidView.ViewState.HIDDEN;
            this.getView().fireChangeEventForProperty(MraidStateProperty.createWithViewState(this.mViewState));
        }
        if (this.getView().getOnCloseListener() != null) {
            this.getView().getOnCloseListener().onClose(this.getView(), this.mViewState);
        }
    }

    private void resetViewToDefaultState() {
        FrameLayout adContainerLayout = (FrameLayout)this.mRootView.findViewById(102);
        RelativeLayout expansionLayout = (RelativeLayout)this.mRootView.findViewById(101);
        this.setNativeCloseButtonEnabled(false);
        adContainerLayout.removeAllViewsInLayout();
        this.mRootView.removeView((View)expansionLayout);
        this.getView().requestLayout();
        ViewGroup parent = (ViewGroup)this.mPlaceholderView.getParent();
        parent.addView((View)this.getView(), this.mViewIndexInParent);
        parent.removeView((View)this.mPlaceholderView);
        parent.invalidate();
    }

    protected void expand(String url, int width, int height, boolean shouldUseCustomClose, boolean shouldLockOrientation) {
        if (this.mExpansionStyle == MraidView.ExpansionStyle.DISABLED) {
            return;
        }
        if (url != null && !URLUtil.isValidUrl((String)url)) {
            this.getView().fireErrorEvent("expand", "URL passed to expand() was invalid.");
            return;
        }
        this.mRootView = (FrameLayout)this.getView().getRootView().findViewById(0x1020002);
        this.useCustomClose(shouldUseCustomClose);
        this.setOrientationLockEnabled(shouldLockOrientation);
        this.swapViewWithPlaceholderView();
        MraidView expansionContentView = this.getView();
        if (url != null) {
            this.mTwoPartExpansionView = new MraidView(this.getView().getContext(), MraidView.ExpansionStyle.DISABLED, MraidView.NativeCloseButtonStyle.AD_CONTROLLED, MraidView.PlacementType.INLINE);
            this.mTwoPartExpansionView.setOnCloseListener(new MraidView.OnCloseListener(){

                @Override
                public void onClose(MraidView view, MraidView.ViewState newViewState) {
                    MraidDisplayController.this.close();
                }
            });
            this.mTwoPartExpansionView.loadUrl(url);
            expansionContentView = this.mTwoPartExpansionView;
        }
        ViewGroup expansionViewContainer = this.createExpansionViewContainer((View)expansionContentView, (int)((float)width * this.mDensity), (int)((float)height * this.mDensity));
        this.mRootView.addView((View)expansionViewContainer, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        if (this.mNativeCloseButtonStyle == MraidView.NativeCloseButtonStyle.ALWAYS_VISIBLE || !this.mAdWantsCustomCloseButton && this.mNativeCloseButtonStyle != MraidView.NativeCloseButtonStyle.ALWAYS_HIDDEN) {
            this.setNativeCloseButtonEnabled(true);
        }
        this.mViewState = MraidView.ViewState.EXPANDED;
        this.getView().fireChangeEventForProperty(MraidStateProperty.createWithViewState(this.mViewState));
        if (this.getView().getOnExpandListener() != null) {
            this.getView().getOnExpandListener().onExpand(this.getView());
        }
    }

    private void swapViewWithPlaceholderView() {
        ViewGroup parent = (ViewGroup)this.getView().getParent();
        if (parent == null) {
            return;
        }
        this.mPlaceholderView = new FrameLayout(this.getView().getContext());
        int count = parent.getChildCount();
        int index = 0;
        while (index < count) {
            if (parent.getChildAt(index) == this.getView()) break;
            ++index;
        }
        this.mViewIndexInParent = index;
        parent.addView((View)this.mPlaceholderView, index, new ViewGroup.LayoutParams(this.getView().getWidth(), this.getView().getHeight()));
        parent.removeView((View)this.getView());
    }

    private ViewGroup createExpansionViewContainer(View expansionContentView, int expandWidth, int expandHeight) {
        int closeButtonSize = (int)(50.0f * this.mDensity + 0.5f);
        if (expandWidth < closeButtonSize) {
            expandWidth = closeButtonSize;
        }
        if (expandHeight < closeButtonSize) {
            expandHeight = closeButtonSize;
        }
        RelativeLayout expansionLayout = new RelativeLayout(this.getView().getContext());
        expansionLayout.setId(101);
        View dimmingView = new View(this.getView().getContext());
        dimmingView.setBackgroundColor(0);
        dimmingView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return true;
            }
        });
        expansionLayout.addView(dimmingView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        FrameLayout adContainerLayout = new FrameLayout(this.getView().getContext());
        adContainerLayout.setId(102);
        adContainerLayout.addView(expansionContentView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(expandWidth, expandHeight);
        lp.addRule(13);
        expansionLayout.addView((View)adContainerLayout, (ViewGroup.LayoutParams)lp);
        return expansionLayout;
    }

    private void setOrientationLockEnabled(boolean enabled) {
        Context context = this.getView().getContext();
        Activity activity = null;
        try {
            activity = (Activity)context;
            int requestedOrientation = enabled ? activity.getResources().getConfiguration().orientation : this.mOriginalRequestedOrientation;
            activity.setRequestedOrientation(requestedOrientation);
        }
        catch (ClassCastException e) {
            Log.d((String)LOGTAG, (String)"Unable to modify device orientation.");
        }
    }

    protected void setNativeCloseButtonEnabled(boolean enabled) {
        if (this.mRootView == null) {
            return;
        }
        FrameLayout adContainerLayout = (FrameLayout)this.mRootView.findViewById(102);
        if (enabled) {
            if (this.mCloseButton == null) {
                StateListDrawable states = new StateListDrawable();
                states.addState(new int[]{-16842919}, ResourceManager.getStaticResource(this.getView().getContext(), -29));
                states.addState(new int[]{16842919}, ResourceManager.getStaticResource(this.getView().getContext(), -29));
                this.mCloseButton = new ImageButton(this.getView().getContext());
                this.mCloseButton.setImageDrawable((Drawable)states);
                this.mCloseButton.setBackgroundDrawable(null);
                this.mCloseButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        MraidDisplayController.this.close();
                    }
                });
            }
            int buttonSize = (int)(50.0f * this.mDensity + 0.5f);
            FrameLayout.LayoutParams buttonLayout = new FrameLayout.LayoutParams(buttonSize, buttonSize, 5);
            adContainerLayout.addView((View)this.mCloseButton, (ViewGroup.LayoutParams)buttonLayout);
        } else {
            adContainerLayout.removeView((View)this.mCloseButton);
        }
        MraidView view = this.getView();
        if (view.getOnCloseButtonStateChangeListener() != null) {
            view.getOnCloseButtonStateChangeListener().onCloseButtonStateChange(view, enabled);
        }
    }

    protected void useCustomClose(boolean shouldUseCustomCloseButton) {
        boolean enabled;
        this.mAdWantsCustomCloseButton = shouldUseCustomCloseButton;
        MraidView view = this.getView();
        boolean bl = enabled = !shouldUseCustomCloseButton;
        if (view.getOnCloseButtonStateChangeListener() != null) {
            view.getOnCloseButtonStateChangeListener().onCloseButtonStateChange(view, enabled);
        }
    }

    protected boolean checkViewable() {
        return true;
    }
}

