/*
 * Decompiled with CFR 0.152.
 */
package com.adsdk.sdk.video;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.ImageView;

public class AspectRatioImageView
extends ImageView {
    private boolean mFill = false;
    private int mMinW = -1;
    private int mMaxH = -1;

    public AspectRatioImageView(Context context) {
        super(context);
    }

    public AspectRatioImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AspectRatioImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void fillParent(boolean fill, int minWidthDip, int maxHeightDip) {
        this.mFill = fill;
        this.mMaxH = maxHeightDip;
        this.mMinW = minWidthDip;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (!this.mFill || this.getDrawable() == null) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        } else {
            int drawableH = this.getDrawable().getIntrinsicHeight();
            int drawableW = this.getDrawable().getIntrinsicWidth();
            if (drawableW > drawableH) {
                height = width * drawableH / drawableW;
            } else {
                height = width;
                width = height * drawableW / drawableH;
            }
            this.ensureConstraintMetAndSet(width, height, drawableW, drawableH);
        }
    }

    protected int getMeasuredHeight(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (!this.mFill || this.getDrawable() == null) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return 0;
        }
        int drawableH = this.getDrawable().getIntrinsicHeight();
        int drawableW = this.getDrawable().getIntrinsicWidth();
        if (drawableW > drawableH) {
            height = width * drawableH / drawableW;
        } else {
            height = width;
            width = height * drawableW / drawableH;
        }
        return this.getConstrainedHeight(width, height, drawableW, drawableH);
    }

    void ensureConstraintMetAndSet(int measuredWidth, int measuredHeight, int drawableW, int drawableH) {
        boolean portraitImage;
        boolean bl = portraitImage = drawableW < drawableH;
        if (portraitImage) {
            float maxH;
            float minW;
            if (this.mMinW > 0 && (float)measuredWidth < (minW = AspectRatioImageView.dip2pixel(this.mMinW, this.getContext()))) {
                measuredWidth = (int)minW;
                measuredHeight = drawableH / drawableW * measuredWidth;
            }
            if (this.mMaxH > 0 && (float)measuredHeight > (maxH = AspectRatioImageView.dip2pixel(this.mMaxH, this.getContext()))) {
                measuredHeight = (int)maxH;
                measuredWidth = measuredHeight * drawableW / drawableH;
            }
        } else {
            float minW;
            float maxH;
            if (this.mMaxH > 0 && (float)measuredHeight > (maxH = AspectRatioImageView.dip2pixel(this.mMaxH, this.getContext()))) {
                measuredHeight = (int)maxH;
                measuredWidth = measuredHeight * drawableW / drawableH;
            }
            if (this.mMinW > 0 && (float)measuredWidth < (minW = AspectRatioImageView.dip2pixel(this.mMinW, this.getContext()))) {
                measuredWidth = (int)minW;
                measuredHeight = drawableH / drawableW * measuredWidth;
            }
        }
        this.setMeasuredDimension(measuredWidth, measuredHeight);
    }

    int getConstrainedHeight(int measuredWidth, int measuredHeight, int drawableW, int drawableH) {
        boolean portraitImage;
        boolean bl = portraitImage = drawableW < drawableH;
        if (portraitImage) {
            float maxH;
            float minW;
            if (this.mMinW > 0 && (float)measuredWidth < (minW = AspectRatioImageView.dip2pixel(this.mMinW, this.getContext()))) {
                measuredWidth = (int)minW;
                measuredHeight = drawableH / drawableW * measuredWidth;
            }
            if (this.mMaxH > 0 && (float)measuredHeight > (maxH = AspectRatioImageView.dip2pixel(this.mMaxH, this.getContext()))) {
                measuredHeight = (int)maxH;
                measuredWidth = measuredHeight * drawableW / drawableH;
            }
        } else {
            float minW;
            float maxH;
            if (this.mMaxH > 0 && (float)measuredHeight > (maxH = AspectRatioImageView.dip2pixel(this.mMaxH, this.getContext()))) {
                measuredHeight = (int)maxH;
                measuredWidth = measuredHeight * drawableW / drawableH;
            }
            if (this.mMinW > 0 && (float)measuredWidth < (minW = AspectRatioImageView.dip2pixel(this.mMinW, this.getContext()))) {
                measuredWidth = (int)minW;
                measuredHeight = drawableH / drawableW * measuredWidth;
            }
        }
        return measuredHeight;
    }

    public static float dip2pixel(int dip, Context context) {
        Resources r = context.getResources();
        float px = TypedValue.applyDimension((int)1, (float)dip, (DisplayMetrics)r.getDisplayMetrics());
        return px;
    }
}

