/*
 * Decompiled with CFR 0.152.
 */
package com.adsdk.sdk.video;

import com.adsdk.sdk.video.InterstitialData;
import com.adsdk.sdk.video.NavIconData;
import com.adsdk.sdk.video.RichMediaAd;
import com.adsdk.sdk.video.TrackerData;
import com.adsdk.sdk.video.VideoData;
import java.io.CharArrayWriter;
import java.util.HashMap;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ResponseHandler
extends DefaultHandler {
    private RichMediaAd richMediaAd = null;
    HashMap<String, Long> videoList = null;
    private CharArrayWriter contents = new CharArrayWriter();
    private TrackerData currentTracker = new TrackerData();
    private long currentExpiration;
    private boolean insideMarkup = false;
    private boolean insideVideo = false;
    private boolean insideInterstitial = false;
    private boolean insideVideoList = false;

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.contents.write(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("creative")) {
            if (this.getRichMediaAd() == null || this.getRichMediaAd().getVideo() == null) {
                throw new SAXException("Creative tag found outside video node");
            }
            VideoData video = this.getRichMediaAd().getVideo();
            video.videoUrl = this.contents.toString().trim();
        } else if (localName.equals("duration")) {
            if (this.getRichMediaAd() == null || this.getRichMediaAd().getVideo() == null) {
                throw new SAXException("Duration tag found outside video node");
            }
            VideoData video = this.getRichMediaAd().getVideo();
            video.duration = this.getInteger(this.contents.toString().trim());
        } else if (localName.equals("tracker")) {
            if (this.getRichMediaAd() == null || this.getRichMediaAd().getVideo() == null) {
                throw new SAXException("Tracker tag found outside video node");
            }
            VideoData video = this.getRichMediaAd().getVideo();
            this.currentTracker.url = this.contents.toString().trim();
            Vector<String> trackers = null;
            switch (this.currentTracker.type) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    trackers = video.timeTrackingEvents.get(this.currentTracker.time);
                    if (trackers != null) break;
                    trackers = new Vector();
                    video.timeTrackingEvents.put(this.currentTracker.time, trackers);
                    break;
                }
                case 0: {
                    trackers = video.getStartEvents();
                    break;
                }
                case 1: {
                    trackers = video.getCompleteEvents();
                    break;
                }
                case 6: {
                    trackers = video.pauseEvents;
                    break;
                }
                case 7: {
                    trackers = video.unpauseEvents;
                    break;
                }
                case 8: {
                    trackers = video.muteEvents;
                    break;
                }
                case 9: {
                    trackers = video.unmuteEvents;
                    break;
                }
                case 11: {
                    trackers = video.replayEvents;
                    break;
                }
                case 10: {
                    trackers = video.skipEvents;
                }
            }
            if (trackers != null) {
                trackers.add(this.currentTracker.url);
            }
        } else if (localName.equals("htmloverlay")) {
            if (this.getRichMediaAd() == null || this.getRichMediaAd().getVideo() == null) {
                throw new SAXException("htmloverlay tag found outside video node");
            }
            VideoData video = this.getRichMediaAd().getVideo();
            video.htmlOverlayMarkup = this.contents.toString().trim();
            this.insideMarkup = false;
        } else if (localName.equals("video")) {
            if (this.insideVideoList) {
                String url = this.contents.toString().trim();
                this.videoList.put(url, this.currentExpiration);
            }
            this.insideVideo = false;
        } else if (localName.equals("interstitial")) {
            this.insideInterstitial = false;
        } else if (localName.equals("markup")) {
            if (this.getRichMediaAd() == null || this.getRichMediaAd().getInterstitial() == null) {
                throw new SAXException("markup tag found outside interstitial node");
            }
            this.insideMarkup = false;
            InterstitialData inter = this.getRichMediaAd().getInterstitial();
            inter.interstitialMarkup = this.contents.toString().trim();
        } else if (localName.equals("error")) {
            this.getRichMediaAd().setType(2);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.setRichMediaAd(new RichMediaAd());
        this.insideVideoList = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.insideMarkup) return;
        this.contents.reset();
        if (localName.equals("activevideolist")) {
            this.videoList = new HashMap();
            this.insideVideoList = true;
            return;
        } else if (localName.equals("ad")) {
            String type = attributes.getValue("type");
            if ("video-to-interstitial".equalsIgnoreCase(type)) {
                this.getRichMediaAd().setType(3);
            } else if ("interstitial-to-video".equalsIgnoreCase(type)) {
                this.getRichMediaAd().setType(4);
            } else if ("video".equalsIgnoreCase(type)) {
                this.getRichMediaAd().setType(5);
            } else if ("interstitial".equalsIgnoreCase(type)) {
                this.getRichMediaAd().setType(6);
            } else {
                if (!"noAd".equalsIgnoreCase(type)) throw new SAXException("Unknown response type " + type);
                this.getRichMediaAd().setType(2);
            }
            String animation = attributes.getValue("animation");
            if ("fade-in".equalsIgnoreCase(animation)) {
                this.getRichMediaAd().setAnimation(1);
                return;
            } else if ("slide-in-top".equalsIgnoreCase(animation)) {
                this.getRichMediaAd().setAnimation(2);
                return;
            } else if ("slide-in-bottom".equalsIgnoreCase(animation)) {
                this.getRichMediaAd().setAnimation(3);
                return;
            } else if ("slide-in-left".equalsIgnoreCase(animation)) {
                this.getRichMediaAd().setAnimation(4);
                return;
            } else if ("slide-in-right".equalsIgnoreCase(animation)) {
                this.getRichMediaAd().setAnimation(5);
                return;
            } else if ("flip-in".equalsIgnoreCase(animation)) {
                this.getRichMediaAd().setAnimation(6);
                return;
            } else {
                this.getRichMediaAd().setAnimation(0);
            }
            return;
        } else if (localName.equals("video")) {
            if (this.insideVideoList) {
                this.currentExpiration = this.getLong(attributes.getValue("expiration")) * 1000L;
                return;
            } else {
                this.insideVideo = true;
                VideoData video = new VideoData();
                String orientation = attributes.getValue("orientation");
                video.orientation = "landscape".equalsIgnoreCase(orientation) ? 0 : ("portrait".equalsIgnoreCase(orientation) ? 1 : 0);
                if (this.getRichMediaAd() == null) throw new SAXException("Video tag found outside document root");
                if (this.getRichMediaAd().getType() == 6 && this.getRichMediaAd().getType() != 4 && this.getRichMediaAd().getType() != 3) {
                    throw new SAXException("Found Video tag in an interstitial ad:" + this.getRichMediaAd().getType());
                }
                this.getRichMediaAd().setVideo(video);
            }
            return;
        } else if (localName.equals("interstitial")) {
            String url;
            this.insideInterstitial = true;
            InterstitialData inter = new InterstitialData();
            inter.autoclose = this.getInteger(attributes.getValue("autoclose"));
            String type = attributes.getValue("type");
            if ("url".equalsIgnoreCase(type)) {
                inter.interstitialType = 0;
                url = attributes.getValue("url");
                if (url == null || url.length() == 0) {
                    throw new SAXException("Empty url for interstitial type " + type);
                }
                inter.interstitialUrl = url;
            } else if ("markup".equalsIgnoreCase(type)) {
                inter.interstitialType = 1;
                this.insideMarkup = true;
            } else {
                inter.interstitialType = 0;
                url = attributes.getValue("url");
                if (url == null || url.length() == 0) {
                    throw new SAXException("Empty url for interstitial type " + type);
                }
                inter.interstitialUrl = url;
            }
            String orientation = attributes.getValue("orientation");
            inter.orientation = "landscape".equalsIgnoreCase(orientation) ? 0 : ("portrait".equalsIgnoreCase(orientation) ? 1 : 0);
            if (this.getRichMediaAd() == null) throw new SAXException("Interstitial tag found outside document root");
            if (this.getRichMediaAd().getType() == 5 && this.getRichMediaAd().getType() != 4 && this.getRichMediaAd().getType() != 3) {
                throw new SAXException("Found Interstitial tag in a video ad:" + this.getRichMediaAd().getType());
            }
            this.getRichMediaAd().setInterstitial(inter);
            return;
        } else if (localName.equals("creative")) {
            String display;
            if (this.getRichMediaAd() == null || this.getRichMediaAd().getVideo() == null) {
                throw new SAXException("Creative tag found outside video node");
            }
            VideoData video = this.getRichMediaAd().getVideo();
            String delivery = attributes.getValue("delivery");
            video.delivery = "progressive".equalsIgnoreCase(delivery) ? 0 : ("streaming".equalsIgnoreCase(delivery) ? 1 : 1);
            String type = attributes.getValue("type");
            if (type == null || type.length() == 0) {
                type = "application/mp4";
            }
            video.display = "fullscreen".equalsIgnoreCase(display = attributes.getValue("display")) ? 0 : ("normal".equalsIgnoreCase(display) ? 0 : 0);
            video.type = type;
            video.width = this.getInteger(attributes.getValue("width"));
            video.height = this.getInteger(attributes.getValue("height"));
            video.bitrate = this.getInteger(attributes.getValue("bitrate"));
            return;
        } else if (localName.equals("skipbutton")) {
            if (this.insideVideo) {
                if (this.getRichMediaAd() == null || this.getRichMediaAd().getVideo() == null) {
                    throw new SAXException("skipbutton tag found inside wrong video node");
                }
                VideoData video = this.getRichMediaAd().getVideo();
                video.showSkipButton = this.getBoolean(attributes.getValue("show"));
                video.showSkipButtonAfter = this.getInteger(attributes.getValue("showafter"));
                video.skipButtonImage = attributes.getValue("graphic");
                return;
            } else {
                if (!this.insideInterstitial) return;
                if (this.getRichMediaAd() == null || this.getRichMediaAd().getInterstitial() == null) {
                    throw new SAXException("skipbutton tag found inside wrong interstitial node");
                }
                InterstitialData inter = this.getRichMediaAd().getInterstitial();
                inter.showSkipButton = this.getBoolean(attributes.getValue("show"));
                inter.showSkipButtonAfter = this.getInteger(attributes.getValue("showafter"));
                inter.skipButtonImage = attributes.getValue("graphic");
            }
            return;
        } else if (localName.equals("navigation")) {
            if (this.insideVideo) {
                if (this.getRichMediaAd() == null || this.getRichMediaAd().getVideo() == null) {
                    throw new SAXException("navigation tag found inside wrong video node");
                }
                VideoData video = this.getRichMediaAd().getVideo();
                video.showNavigationBars = this.getBoolean(attributes.getValue("show"));
                video.allowTapNavigationBars = this.getBoolean(attributes.getValue("allowtap"));
                return;
            } else {
                if (!this.insideInterstitial) return;
                if (this.getRichMediaAd() == null || this.getRichMediaAd().getInterstitial() == null) {
                    throw new SAXException("navigation tag found inside wrong interstitial node");
                }
                InterstitialData inter = this.getRichMediaAd().getInterstitial();
                inter.showNavigationBars = this.getBoolean(attributes.getValue("show"));
                inter.allowTapNavigationBars = this.getBoolean(attributes.getValue("allowtap"));
            }
            return;
        } else if (localName.equals("topbar")) {
            if (this.insideVideo) {
                if (this.getRichMediaAd() == null || this.getRichMediaAd().getVideo() == null) {
                    throw new SAXException("topbar tag found inside wrong video node");
                }
                VideoData video = this.getRichMediaAd().getVideo();
                video.showTopNavigationBar = this.getBoolean(attributes.getValue("show"));
                video.topNavigationBarBackground = attributes.getValue("custombackgroundurl");
                return;
            } else {
                if (!this.insideInterstitial) return;
                if (this.getRichMediaAd() == null || this.getRichMediaAd().getInterstitial() == null) {
                    throw new SAXException("topbar tag found inside wrong interstitial node");
                }
                InterstitialData inter = this.getRichMediaAd().getInterstitial();
                inter.showTopNavigationBar = this.getBoolean(attributes.getValue("show"));
                inter.topNavigationBarBackground = attributes.getValue("custombackgroundurl");
                String titleType = attributes.getValue("title");
                if ("fixed".equalsIgnoreCase(titleType)) {
                    inter.topNavigationBarTitleType = 0;
                    inter.topNavigationBarTitle = attributes.getValue("titlecontent");
                    return;
                } else {
                    inter.topNavigationBarTitleType = "variable".equalsIgnoreCase(titleType) ? 1 : 2;
                }
            }
            return;
        } else if (localName.equals("bottombar")) {
            if (this.insideVideo) {
                if (this.getRichMediaAd() == null || this.getRichMediaAd().getVideo() == null) {
                    throw new SAXException("bottombar tag found inside wrong video node");
                }
                VideoData video = this.getRichMediaAd().getVideo();
                video.showBottomNavigationBar = this.getBoolean(attributes.getValue("show"));
                video.bottomNavigationBarBackground = attributes.getValue("custombackgroundurl");
                video.showPauseButton = this.getBoolean(attributes.getValue("pausebutton"));
                video.showReplayButton = this.getBoolean(attributes.getValue("replaybutton"));
                video.showTimer = this.getBoolean(attributes.getValue("timer"));
                video.pauseButtonImage = attributes.getValue("pausebuttonurl");
                video.playButtonImage = attributes.getValue("playbuttonurl");
                video.replayButtonImage = attributes.getValue("replaybuttonurl");
                return;
            } else {
                if (!this.insideInterstitial) return;
                if (this.getRichMediaAd() == null || this.getRichMediaAd().getInterstitial() == null) {
                    throw new SAXException("bottombar tag found inside wrong interstitial node");
                }
                InterstitialData inter = this.getRichMediaAd().getInterstitial();
                inter.showBottomNavigationBar = this.getBoolean(attributes.getValue("show"));
                inter.bottomNavigationBarBackground = attributes.getValue("custombackgroundurl");
                inter.showBackButton = this.getBoolean(attributes.getValue("backbutton"));
                inter.showForwardButton = this.getBoolean(attributes.getValue("forwardbutton"));
                inter.showReloadButton = this.getBoolean(attributes.getValue("reloadbutton"));
                inter.showExternalButton = this.getBoolean(attributes.getValue("externalbutton"));
                inter.showTimer = this.getBoolean(attributes.getValue("timer"));
                inter.backButtonImage = attributes.getValue("backbuttonurl");
                inter.forwardButtonImage = attributes.getValue("forwardbuttonurl");
                inter.reloadButtonImage = attributes.getValue("reloadbuttonurl");
                inter.externalButtonImage = attributes.getValue("externalbuttonurl");
            }
            return;
        } else if (localName.equals("navicon")) {
            if (this.insideVideo) {
                if (this.getRichMediaAd() == null || this.getRichMediaAd().getVideo() == null) {
                    throw new SAXException("navicon tag found inside wrong video node");
                }
                VideoData video = this.getRichMediaAd().getVideo();
                NavIconData icon = new NavIconData();
                icon.title = attributes.getValue("title");
                icon.clickUrl = attributes.getValue("clickurl");
                icon.iconUrl = attributes.getValue("iconurl");
                String type = attributes.getValue("opentype");
                icon.openType = "inapp".equalsIgnoreCase(type) ? 0 : 1;
                video.icons.add(icon);
                return;
            } else {
                if (!this.insideInterstitial) return;
                if (this.getRichMediaAd() == null || this.getRichMediaAd().getInterstitial() == null) {
                    throw new SAXException("navicon tag found inside wrong interstitial node");
                }
                InterstitialData inter = this.getRichMediaAd().getInterstitial();
                NavIconData icon = new NavIconData();
                icon.title = attributes.getValue("title");
                icon.clickUrl = attributes.getValue("clickurl");
                icon.iconUrl = attributes.getValue("iconurl");
                String type = attributes.getValue("opentype");
                icon.openType = "inapp".equalsIgnoreCase(type) ? 0 : 1;
                inter.icons.add(icon);
            }
            return;
        } else if (localName.equals("tracker")) {
            if (!this.insideVideo) return;
            if (this.getRichMediaAd() == null || this.getRichMediaAd().getVideo() == null) {
                throw new SAXException("tracker tag found inside wrong video node");
            }
            VideoData video = this.getRichMediaAd().getVideo();
            this.currentTracker.reset();
            String type = attributes.getValue("type");
            if ("start".equalsIgnoreCase(type)) {
                this.currentTracker.type = 0;
                return;
            } else if ("complete".equalsIgnoreCase(type)) {
                this.currentTracker.type = 1;
                return;
            } else if ("midpoint".equalsIgnoreCase(type)) {
                this.currentTracker.type = 2;
                this.currentTracker.time = video.duration / 2;
                return;
            } else if ("firstquartile".equalsIgnoreCase(type)) {
                this.currentTracker.type = 3;
                this.currentTracker.time = video.duration / 4;
                return;
            } else if ("thirdquartile".equalsIgnoreCase(type)) {
                this.currentTracker.type = 4;
                this.currentTracker.time = 3 * video.duration / 4;
                return;
            } else if ("pause".equalsIgnoreCase(type)) {
                this.currentTracker.type = 6;
                return;
            } else if ("unpause".equalsIgnoreCase(type)) {
                this.currentTracker.type = 7;
                return;
            } else if ("mute".equalsIgnoreCase(type)) {
                this.currentTracker.type = 8;
                return;
            } else if ("unmute".equalsIgnoreCase(type)) {
                this.currentTracker.type = 9;
                return;
            } else if ("replay".equalsIgnoreCase(type)) {
                this.currentTracker.type = 11;
                return;
            } else if ("skip".equalsIgnoreCase(type)) {
                this.currentTracker.type = 10;
                return;
            } else {
                if (type == null || !type.startsWith("sec:")) return;
                this.currentTracker.type = 5;
                this.currentTracker.time = this.getInteger(type.substring(4));
            }
            return;
        } else {
            if (!localName.equals("htmloverlay") || !this.insideVideo) return;
            if (this.getRichMediaAd() == null || this.getRichMediaAd().getVideo() == null) {
                throw new SAXException("htmloverlay tag found inside wrong video node");
            }
            VideoData video = this.getRichMediaAd().getVideo();
            this.insideMarkup = true;
            String type = attributes.getValue("type");
            if ("url".equalsIgnoreCase(type)) {
                video.htmlOverlayType = 0;
                String url = attributes.getValue("url");
                if (url == null || url.length() == 0) {
                    throw new SAXException("Empty url for overlay type " + type);
                }
                video.htmlOverlayUrl = url;
            } else if ("markup".equalsIgnoreCase(type)) {
                video.htmlOverlayType = 1;
                this.insideMarkup = true;
            } else {
                video.htmlOverlayType = 0;
                String url = attributes.getValue("url");
                if (url == null || url.length() == 0) {
                    throw new SAXException("Empty url for overlay type " + type);
                }
                video.htmlOverlayUrl = url;
            }
            video.showHtmlOverlayAfter = this.getInteger(attributes.getValue("showafter"));
            video.showHtmlOverlay = this.getBoolean(attributes.getValue("show"));
        }
    }

    private int getInteger(String text) {
        if (text == null) {
            return -1;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private long getLong(String text) {
        if (text == null) {
            return -1L;
        }
        try {
            return Long.parseLong(text);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    private boolean getBoolean(String text) {
        if (text == null) {
            return false;
        }
        try {
            return Integer.parseInt(text) > 0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public RichMediaAd getRichMediaAd() {
        return this.richMediaAd;
    }

    public void setRichMediaAd(RichMediaAd richMediaAd) {
        this.richMediaAd = richMediaAd;
    }
}

