/*
 * Decompiled with CFR 0.152.
 */
package com.adsdk.sdk.video;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Message;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.adsdk.sdk.Log;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.client.methods.HttpGet;

public class ResourceManager {
    public static final int RESOURCE_LOADED_MSG = 100;
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_FILE = 0;
    public static final int TYPE_ZIP = 1;
    public static boolean sDownloading = false;
    public static boolean sCancel = false;
    public static HttpGet sDownloadGet;
    public static final String VERSION = "version.txt";
    public static final String TOPBAR_BG = "bar.png";
    public static final String BOTTOMBAR_BG = "bar.png";
    public static final String PLAY_ICON = "video_play.png";
    public static final String PAUSE_ICON = "video_pause.png";
    public static final String REPLAY_ICON = "video_replay.png";
    public static final String BACK_ICON = "browser_back.png";
    public static final String FORWARD_ICON = "browser_forward.png";
    public static final String RELOAD_ICON = "video_replay.png";
    public static final String EXTERNAL_ICON = "browser_external.png";
    public static final String SKIP_ICON = "skip.png";
    public static final String CLOSE_BUTTON_NORMAL = "close_button_normal.png";
    public static final String CLOSE_BUTTON_PRESSED = "close_button_pressed.png";
    public static final int DEFAULT_TOPBAR_BG_RESOURCE_ID = -1;
    public static final int DEFAULT_BOTTOMBAR_BG_RESOURCE_ID = -2;
    public static final int DEFAULT_PLAY_IMAGE_RESOURCE_ID = -11;
    public static final int DEFAULT_PAUSE_IMAGE_RESOURCE_ID = -12;
    public static final int DEFAULT_REPLAY_IMAGE_RESOURCE_ID = -13;
    public static final int DEFAULT_BACK_IMAGE_RESOURCE_ID = -14;
    public static final int DEFAULT_FORWARD_IMAGE_RESOURCE_ID = -15;
    public static final int DEFAULT_RELOAD_IMAGE_RESOURCE_ID = -16;
    public static final int DEFAULT_EXTERNAL_IMAGE_RESOURCE_ID = -17;
    public static final int DEFAULT_SKIP_IMAGE_RESOURCE_ID = -18;
    public static final int DEFAULT_CLOSE_BUTTON_NORMAL_RESOURCE_ID = -29;
    public static final int DEFAULT_CLOSE_BUTTON_PRESSED_RESOURCE_ID = -30;
    private static HashMap<Integer, Drawable> sResources;
    private Handler mHandler;
    private HashMap<Integer, Drawable> mResources = new HashMap();

    static {
        sResources = new HashMap();
    }

    public static Drawable getDefaultResource(int resId) {
        return sResources.get(resId);
    }

    public static Drawable getDefaultSkipButton(Context ctx) {
        return ResourceManager.buildDrawable(ctx, SKIP_ICON);
    }

    public static boolean resourcesInstalled(Context ctx) {
        boolean result = false;
        String[] files = ctx.fileList();
        int i = 0;
        while (i < files.length) {
            if (VERSION.equals(files[i])) {
                Log.d("Resources already installed");
                return true;
            }
            ++i;
        }
        return result;
    }

    public static long getInstalledVersion(Context ctx) {
        long result;
        block14: {
            result = -1L;
            FileInputStream in = null;
            try {
                try {
                    in = ctx.openFileInput(VERSION);
                    InputStreamReader isr = new InputStreamReader((InputStream)in, "UTF-8");
                    BufferedReader reader = new BufferedReader(isr);
                    String version = reader.readLine();
                    result = Long.valueOf(version);
                }
                catch (Exception exception) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exception2) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Log.d("Resources installed version:" + result);
        return result;
    }

    public static void saveInstalledVersion(Context ctx, long version) {
        block12: {
            FileOutputStream out = null;
            try {
                try {
                    out = ctx.openFileOutput(VERSION, 0);
                    OutputStreamWriter osr = new OutputStreamWriter((OutputStream)out, "UTF-8");
                    osr.write(String.valueOf(version));
                    osr.flush();
                }
                catch (Exception exception) {
                    if (out == null) break block12;
                    try {
                        out.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public void releaseInstance() {
        Iterator<Map.Entry<Integer, Drawable>> it = this.mResources.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, Drawable> pairsEntry = it.next();
            it.remove();
            BitmapDrawable bitmapDrawable = (BitmapDrawable)pairsEntry.getValue();
        }
        assert (this.mResources.size() == 0);
        System.gc();
    }

    private static void initDefaultResource(Context ctx, int resource) {
        switch (resource) {
            case -11: {
                ResourceManager.registerImageResource(ctx, -11, PLAY_ICON);
                break;
            }
            case -12: {
                ResourceManager.registerImageResource(ctx, -12, PAUSE_ICON);
                break;
            }
            case -13: {
                ResourceManager.registerImageResource(ctx, -13, "video_replay.png");
                break;
            }
            case -14: {
                ResourceManager.registerImageResource(ctx, -14, BACK_ICON);
                break;
            }
            case -15: {
                ResourceManager.registerImageResource(ctx, -15, FORWARD_ICON);
                break;
            }
            case -16: {
                ResourceManager.registerImageResource(ctx, -16, "video_replay.png");
                break;
            }
            case -17: {
                ResourceManager.registerImageResource(ctx, -17, EXTERNAL_ICON);
                break;
            }
            case -18: {
                ResourceManager.registerImageResource(ctx, -18, SKIP_ICON);
                break;
            }
            case -1: {
                ResourceManager.registerImageResource(ctx, -1, "bar.png");
                break;
            }
            case -2: {
                ResourceManager.registerImageResource(ctx, -2, "bar.png");
                break;
            }
            case -29: {
                ResourceManager.registerImageResource(ctx, -29, CLOSE_BUTTON_NORMAL);
                break;
            }
            case -30: {
                ResourceManager.registerImageResource(ctx, -30, CLOSE_BUTTON_PRESSED);
            }
        }
    }

    private static void registerImageResource(Context ctx, int resId, String name) {
        Drawable d = ResourceManager.buildDrawable(ctx, name);
        if (d != null) {
            sResources.put(resId, d);
        } else {
            Log.i("registerImageResource", "drawable was null " + name);
        }
    }

    private static Drawable buildDrawable(Context ctx, String name) {
        InputStream in = null;
        try {
            in = ctx.getClass().getClassLoader().getResourceAsStream("defaultresources/" + name);
            Bitmap b = BitmapFactory.decodeStream((InputStream)in);
            if (b != null) {
                DisplayMetrics m = ctx.getResources().getDisplayMetrics();
                int w = b.getWidth();
                int h = b.getHeight();
                int imageWidth = (int)TypedValue.applyDimension((int)1, (float)w, (DisplayMetrics)m);
                int imageHeight = (int)TypedValue.applyDimension((int)1, (float)h, (DisplayMetrics)m);
                if (imageWidth != w || imageHeight != h) {
                    b = Bitmap.createScaledBitmap((Bitmap)b, (int)imageWidth, (int)imageHeight, (boolean)false);
                }
                BitmapDrawable bitmapDrawable = new BitmapDrawable(ctx.getResources(), b);
                return bitmapDrawable;
            }
        }
        catch (Exception e) {
            Log.i("ResourceManager cannot find resource " + name);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                    in = null;
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    public static boolean isDownloading() {
        return sDownloading;
    }

    public static void cancel() {
        sCancel = true;
        if (sDownloadGet != null) {
            sDownloadGet.abort();
            sDownloadGet = null;
        }
        sResources.clear();
    }

    public ResourceManager(Context ctx, Handler h) {
        this.mHandler = h;
    }

    public void fetchResource(Context ctx, String url, int resourceId) {
        if (sResources.get(resourceId) == null) {
            new FetchImageTask(ctx, url, resourceId).execute(new Void[0]);
        }
    }

    public boolean containsResource(int resourceId) {
        return this.mResources.get(resourceId) != null || this.mResources.get(resourceId) != null;
    }

    public Drawable getResource(Context ctx, int resourceId) {
        BitmapDrawable d = (BitmapDrawable)this.mResources.get(resourceId);
        if (d != null) {
            return d;
        }
        return ResourceManager.getStaticResource(ctx, resourceId);
    }

    public static Drawable getStaticResource(Context ctx, int resourceId) {
        BitmapDrawable d = (BitmapDrawable)sResources.get(resourceId);
        if (d == null || d.getBitmap().isRecycled()) {
            ResourceManager.initDefaultResource(ctx, resourceId);
            d = (BitmapDrawable)sResources.get(resourceId);
        }
        return d;
    }

    private class FetchImageTask
    extends AsyncTask<Void, Void, Boolean> {
        String mUrl;
        int mResourceId;
        Context mContext;

        public FetchImageTask(Context ctx, String url, int resId) {
            this.mContext = ctx;
            this.mUrl = url;
            this.mResourceId = resId;
            Log.i("Fetching: " + this.mUrl);
        }

        protected void onPostExecute(Boolean result) {
            super.onPostExecute((Object)result);
            Log.i("Fetched: " + this.mUrl);
            Message msg = ResourceManager.this.mHandler.obtainMessage(100, this.mResourceId, 0);
            ResourceManager.this.mHandler.sendMessage(msg);
        }

        protected Boolean doInBackground(Void ... params) {
            Drawable d = null;
            if (this.mUrl != null && this.mUrl.length() > 0) {
                d = this.fetchImage(this.mUrl);
            }
            if (d != null) {
                ResourceManager.this.mResources.put(this.mResourceId, d);
                return true;
            }
            return false;
        }

        private Drawable fetchImage(String urlString) {
            try {
                URL url = new URL(urlString);
                InputStream is = (InputStream)url.getContent();
                Bitmap b = BitmapFactory.decodeStream((InputStream)is);
                if (b != null) {
                    DisplayMetrics m = this.mContext.getResources().getDisplayMetrics();
                    int w = b.getWidth();
                    int h = b.getHeight();
                    int imageWidth = (int)TypedValue.applyDimension((int)1, (float)w, (DisplayMetrics)m);
                    int imageHeight = (int)TypedValue.applyDimension((int)1, (float)h, (DisplayMetrics)m);
                    if (imageWidth != w || imageHeight != h) {
                        b = Bitmap.createScaledBitmap((Bitmap)b, (int)imageWidth, (int)imageHeight, (boolean)false);
                    }
                    return new BitmapDrawable(this.mContext.getResources(), b);
                }
            }
            catch (Exception e) {
                Log.e("Cannot fetch image:" + urlString, e);
            }
            return null;
        }
    }
}

