/*
 * Decompiled with CFR 0.152.
 */
package com.adsdk.sdk.video;

import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.MediaController;
import android.widget.TextView;
import com.adsdk.sdk.Log;
import com.adsdk.sdk.video.AspectRatioImageViewWidth;
import com.adsdk.sdk.video.AutoResizeTextView;
import com.adsdk.sdk.video.NavIcon;
import com.adsdk.sdk.video.NavIconData;
import com.adsdk.sdk.video.ResourceManager;
import com.adsdk.sdk.video.VideoData;
import java.lang.ref.WeakReference;
import java.util.Formatter;
import java.util.Locale;

public class MediaController
extends FrameLayout {
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final int FADE_OUT = 1;
    private static final int SHOW_PROGRESS = 2;
    private double buttonWidthPercent = 0.09;
    private MediaController.MediaPlayerControl mPlayer;
    private Context mContext;
    private ResourceManager mResourceManager;
    private LinearLayout mTopBar;
    private LinearLayout mBottomBar;
    private AspectRatioImageViewWidth mPauseButton;
    private AspectRatioImageViewWidth mReplayButton;
    private TextView mLeftTime;
    private VideoData mVideoData;
    StringBuilder mFormatBuilder;
    Formatter mFormatter;
    private boolean mShowing;
    private boolean mFixed;
    private OnUnpauseListener mOnUnpauseListener;
    private OnPauseListener mOnPauseListener;
    private OnReplayListener mOnReplayListener;
    private ResourceHandler mHandler = new ResourceHandler(this);
    private View.OnClickListener mPauseListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaController.this.doPauseResume();
        }
    };
    private View.OnClickListener mReplayListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaController.this.replay();
        }
    };

    public MediaController(Context context, VideoData videoData) {
        super(context);
        this.setVisibility(8);
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(metrics);
        this.mShowing = false;
        this.mFixed = false;
        this.mContext = context;
        this.mVideoData = videoData;
        if (this.mVideoData == null) {
            throw new IllegalArgumentException("Video info cannot be null");
        }
        this.mFormatBuilder = new StringBuilder();
        this.mFormatter = new Formatter(this.mFormatBuilder, Locale.getDefault());
        this.mResourceManager = new ResourceManager(this.mContext, this.mHandler);
        this.buildNavigationBarView(metrics);
        Log.d("MediaController created");
    }

    public void setMediaPlayer(MediaController.MediaPlayerControl player) {
        this.mPlayer = player;
        this.updatePausePlay();
    }

    protected void buildNavigationBarView(DisplayMetrics metrics) {
        int barHeight = metrics.widthPixels;
        this.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mTopBar = new LinearLayout(this.mContext);
        this.mTopBar.setOrientation(0);
        this.mTopBar.setWeightSum(1.0f);
        this.mTopBar.setBackgroundColor(0);
        FrameLayout.LayoutParams paramsFrame = new FrameLayout.LayoutParams(-1, (int)((double)barHeight * 0.119));
        paramsFrame.gravity = 55;
        this.mTopBar.setGravity(16);
        int padding = (int)TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.addView((View)this.mTopBar, (ViewGroup.LayoutParams)paramsFrame);
        this.mBottomBar = new LinearLayout(this.mContext);
        this.mBottomBar.setOrientation(0);
        this.mBottomBar.setGravity(16);
        paramsFrame = new FrameLayout.LayoutParams(-1, (int)((double)barHeight * 0.119));
        paramsFrame.gravity = 80;
        this.mBottomBar.setWeightSum(1.0f);
        this.mBottomBar.setPadding(padding, 0, padding, 0);
        this.mBottomBar.setBackgroundColor(0);
        this.addView((View)this.mBottomBar, (ViewGroup.LayoutParams)paramsFrame);
        LinearLayout buttonPanel = new LinearLayout(this.mContext);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -1);
        params.gravity = 3;
        buttonPanel.setOrientation(0);
        buttonPanel.setGravity(16);
        buttonPanel.setBackgroundColor(-16711936);
        this.mReplayButton = new AspectRatioImageViewWidth(this.mContext);
        params = new LinearLayout.LayoutParams((int)((double)barHeight * this.buttonWidthPercent), (int)((double)barHeight * this.buttonWidthPercent));
        params.gravity = 16;
        this.mReplayButton.setAdjustViewBounds(true);
        this.mReplayButton.setPadding(padding, padding, padding, padding);
        this.mBottomBar.addView((View)this.mReplayButton, (ViewGroup.LayoutParams)params);
        this.mPauseButton = new AspectRatioImageViewWidth(this.mContext);
        params = new LinearLayout.LayoutParams((int)((double)barHeight * this.buttonWidthPercent), (int)((double)barHeight * this.buttonWidthPercent));
        params.gravity = 16;
        this.mPauseButton.setPadding(padding, padding, padding, padding);
        this.mPauseButton.setAdjustViewBounds(true);
        this.mBottomBar.addView((View)this.mPauseButton, (ViewGroup.LayoutParams)params);
        this.mLeftTime = new AutoResizeTextView(this.mContext);
        params = new LinearLayout.LayoutParams(-2, -2);
        params.gravity = 16;
        this.mLeftTime.setTypeface(Typeface.defaultFromStyle((int)1));
        this.mLeftTime.setPadding(padding, padding, padding, padding);
        this.mLeftTime.setGravity(16);
        this.mLeftTime.setTextSize(23.0f);
        this.mBottomBar.addView((View)this.mLeftTime, (ViewGroup.LayoutParams)params);
        View view = new View(this.mContext);
        params = new LinearLayout.LayoutParams(0, 0);
        params.weight = 1.0f;
        params.gravity = 16;
        this.mBottomBar.addView(view, (ViewGroup.LayoutParams)params);
        this.initNavigationBarControllerView(padding, metrics);
    }

    private void initNavigationBarControllerView(int padding, DisplayMetrics metrics) {
        int barHeight = metrics.widthPixels;
        if (!this.mVideoData.showBottomNavigationBar) {
            this.mBottomBar.setVisibility(8);
        } else {
            this.mBottomBar.setVisibility(0);
            if (this.mVideoData.bottomNavigationBarBackground != null && this.mVideoData.bottomNavigationBarBackground.length() > 0) {
                this.mResourceManager.fetchResource(this.mContext, this.mVideoData.bottomNavigationBarBackground, -2);
            } else {
                this.mBottomBar.setBackgroundDrawable(this.mResourceManager.getResource(this.mContext, -2));
            }
            if (this.mPauseButton != null) {
                if (this.mVideoData.pauseButtonImage != null && this.mVideoData.pauseButtonImage.length() > 0) {
                    this.mPauseButton.setBackgroundDrawable(null);
                    this.mResourceManager.fetchResource(this.mContext, this.mVideoData.pauseButtonImage, -12);
                } else {
                    this.mPauseButton.setImageDrawable(this.mResourceManager.getResource(this.mContext, -12));
                }
                if (this.mVideoData.playButtonImage != null && this.mVideoData.playButtonImage.length() > 0) {
                    this.mResourceManager.fetchResource(this.mContext, this.mVideoData.playButtonImage, -11);
                }
                this.mPauseButton.setOnClickListener(this.mPauseListener);
                if (this.mVideoData.showPauseButton) {
                    this.mPauseButton.setVisibility(0);
                } else {
                    this.mPauseButton.setVisibility(8);
                }
            }
            if (this.mReplayButton != null) {
                if (this.mVideoData.replayButtonImage != null && this.mVideoData.replayButtonImage.length() > 0) {
                    this.mReplayButton.setImageDrawable(null);
                    this.mResourceManager.fetchResource(this.mContext, this.mVideoData.replayButtonImage, -13);
                } else {
                    this.mReplayButton.setImageDrawable(this.mResourceManager.getResource(this.mContext, -13));
                }
                this.mReplayButton.setOnClickListener(this.mReplayListener);
                if (this.mVideoData.showReplayButton) {
                    this.mReplayButton.setVisibility(0);
                } else {
                    this.mReplayButton.setVisibility(8);
                }
            }
            if (this.mLeftTime != null) {
                if (this.mVideoData.showTimer) {
                    this.mLeftTime.setVisibility(0);
                } else {
                    this.mLeftTime.setVisibility(8);
                }
            }
            if (!this.mVideoData.icons.isEmpty()) {
                int i = 0;
                while (i < this.mVideoData.icons.size()) {
                    NavIconData iconData = this.mVideoData.icons.get(i);
                    NavIcon icon = new NavIcon(this.mContext, iconData);
                    LinearLayout.LayoutParams params = new LinearLayout.LayoutParams((int)((double)barHeight * this.buttonWidthPercent), (int)((double)barHeight * this.buttonWidthPercent));
                    this.mBottomBar.addView((View)icon, (ViewGroup.LayoutParams)params);
                    ++i;
                }
            }
        }
        if (!this.mVideoData.showTopNavigationBar) {
            this.mTopBar.setVisibility(8);
        } else {
            this.mTopBar.setVisibility(0);
            if (this.mVideoData.topNavigationBarBackground != null && this.mVideoData.topNavigationBarBackground.length() > 0) {
                this.mResourceManager.fetchResource(this.mContext, this.mVideoData.topNavigationBarBackground, -1);
            } else {
                this.mTopBar.setBackgroundDrawable(this.mResourceManager.getResource(this.mContext, -1));
            }
        }
        if (!this.mVideoData.showNavigationBars) {
            this.setVisibility(8);
        }
    }

    public void show() {
        this.show(5000);
    }

    public void show(int timeout) {
        Log.d("SHOW:" + timeout);
        if (timeout == 0) {
            this.mFixed = true;
        }
        if (!this.mShowing) {
            this.setVisibility(0);
            this.mShowing = true;
            Log.d("Change Visibility");
        }
        this.refreshProgress();
        this.mHandler.removeMessages(1);
        if (timeout != 0 && !this.mFixed) {
            Message msg = this.mHandler.obtainMessage(1);
            this.mHandler.sendMessageDelayed(msg, timeout);
        }
    }

    public boolean isShowing() {
        return this.mShowing;
    }

    public void hide() {
        Log.d("HIDE");
        this.mFixed = false;
        if (this.canToggle()) {
            Log.d("Hide can toggle");
            if (this.mShowing) {
                Log.d("Hide change visibility");
                this.mHandler.removeMessages(2);
                this.setVisibility(8);
                this.mShowing = false;
            }
        }
    }

    public void resizeTopBar(int bottom) {
        if (bottom <= 0) {
            return;
        }
        int padding = (int)TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        if (this.mTopBar != null) {
            ViewGroup.LayoutParams params = this.mTopBar.getLayoutParams();
            params.height = bottom + padding;
            this.mTopBar.setLayoutParams(params);
        }
    }

    public void replay() {
        if (this.mPlayer != null) {
            this.mPlayer.seekTo(0);
            this.mPlayer.start();
        }
        this.refreshProgress();
        if (this.mOnReplayListener != null) {
            this.mOnReplayListener.onVideoReplay();
        }
    }

    private void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.hide();
                break;
            }
            case 2: {
                this.refreshProgress();
                break;
            }
            case 100: {
                switch (msg.arg1) {
                    case -1: {
                        Drawable d;
                        if (this.mTopBar == null || (d = this.mResourceManager.getResource(this.mContext, -1)) == null) break;
                        this.mTopBar.setBackgroundDrawable(d);
                        break;
                    }
                    case -2: {
                        Drawable d;
                        if (this.mBottomBar == null || (d = this.mResourceManager.getResource(this.mContext, -2)) == null) break;
                        this.mBottomBar.setBackgroundDrawable(d);
                        break;
                    }
                    case -11: {
                        if (this.mPauseButton == null) break;
                        this.updatePausePlay();
                        break;
                    }
                    case -12: {
                        if (this.mPauseButton == null) break;
                        this.updatePausePlay();
                        break;
                    }
                    case -13: {
                        if (this.mReplayButton == null) break;
                        this.updateReplay();
                    }
                }
                this.requestLayout();
            }
        }
    }

    private String stringForTime(int timeMs) {
        int totalSeconds = timeMs / 1000;
        int seconds = totalSeconds % 60;
        int minutes = totalSeconds / 60 % 60;
        int hours = totalSeconds / 3600;
        this.mFormatBuilder.setLength(0);
        if (hours > 0) {
            return this.mFormatter.format("%d:%02d:%02d", hours, minutes, seconds).toString();
        }
        if (minutes > 0) {
            return this.mFormatter.format("%02d:%02d", minutes, seconds).toString();
        }
        return this.mFormatter.format("0:%02d", seconds).toString();
    }

    private int setProgress() {
        if (this.mPlayer == null) {
            return 0;
        }
        int position = this.mPlayer.getCurrentPosition();
        int duration = this.mPlayer.getDuration();
        int timeLeft = duration - position;
        if (this.mLeftTime != null) {
            this.mLeftTime.setText((CharSequence)this.stringForTime(timeLeft));
        }
        return position;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode != 4 && keyCode != 24 && keyCode != 25 && keyCode != 82 && keyCode != 5 && keyCode != 6) {
            if (keyCode == 79 || keyCode == 85) {
                this.doPauseResume();
                return true;
            }
            if (keyCode == 86 && this.mPlayer != null && this.mPlayer.isPlaying()) {
                this.mPlayer.pause();
                if (this.mOnPauseListener != null) {
                    this.mOnPauseListener.onVideoPause();
                }
            } else {
                this.toggle();
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    private void updateReplay() {
        if (this.mReplayButton == null) {
            return;
        }
        if (this.mResourceManager.containsResource(-13)) {
            Drawable d = this.mResourceManager.getResource(this.mContext, -13);
            this.mReplayButton.setImageDrawable(d);
        } else {
            Drawable d = this.mResourceManager.getResource(this.mContext, -13);
            this.mReplayButton.setImageDrawable(d);
        }
    }

    private void updatePausePlay() {
        if (this.mPauseButton == null) {
            return;
        }
        if (this.mPlayer != null && this.mPlayer.isPlaying()) {
            if (this.mResourceManager.containsResource(-12)) {
                Drawable d = this.mResourceManager.getResource(this.mContext, -12);
                this.mPauseButton.setImageDrawable(d);
            } else {
                Drawable d = this.mResourceManager.getResource(this.mContext, -12);
                this.mPauseButton.setImageDrawable(d);
            }
        } else if (this.mResourceManager.containsResource(-11)) {
            Drawable d = this.mResourceManager.getResource(this.mContext, -11);
            this.mPauseButton.setImageDrawable(d);
        } else {
            Drawable d = this.mResourceManager.getResource(this.mContext, -11);
            this.mPauseButton.setImageDrawable(d);
        }
    }

    private void doPauseResume() {
        if (this.mPlayer == null) {
            return;
        }
        if (this.mPlayer.isPlaying()) {
            this.mPlayer.pause();
            if (this.mOnPauseListener != null) {
                this.mOnPauseListener.onVideoPause();
            }
        } else {
            this.mPlayer.start();
            if (this.mOnUnpauseListener != null) {
                this.mOnUnpauseListener.onVideoUnpause();
            }
        }
        this.updatePausePlay();
    }

    public boolean canToggle() {
        return this.mVideoData.allowTapNavigationBars;
    }

    public void toggle() {
        if (this.canToggle()) {
            if (this.mShowing) {
                this.hide();
            } else {
                this.show();
            }
        }
    }

    public void onStart() {
        this.refreshProgress();
    }

    private void refreshProgress() {
        if (this.mShowing) {
            this.updatePausePlay();
            int pos = this.setProgress();
            if (this.mPlayer != null && this.mPlayer.isPlaying()) {
                this.mHandler.removeMessages(2);
                Message msg = this.mHandler.obtainMessage(2);
                this.mHandler.sendMessageDelayed(msg, 1000 - pos % 1000);
            }
        }
    }

    public void onPause() {
        this.show(0);
    }

    public void setOnPauseListener(OnPauseListener l) {
        this.mOnPauseListener = l;
    }

    public void setOnUnpauseListener(OnUnpauseListener l) {
        this.mOnUnpauseListener = l;
    }

    public void setOnReplayListener(OnReplayListener l) {
        this.mOnReplayListener = l;
    }

    public static interface OnPauseListener {
        public void onVideoPause();
    }

    public static interface OnReplayListener {
        public void onVideoReplay();
    }

    public static interface OnUnpauseListener {
        public void onVideoUnpause();
    }

    private static class ResourceHandler
    extends Handler {
        private final WeakReference<MediaController> mController;

        public ResourceHandler(MediaController controller) {
            this.mController = new WeakReference<MediaController>(controller);
        }

        public void handleMessage(Message msg) {
            MediaController wController = (MediaController)((Object)this.mController.get());
            if (wController != null) {
                wController.handleMessage(msg);
            }
        }
    }
}

