/*
 * Decompiled with CFR 0.152.
 */
package com.adsdk.sdk.video;

import android.content.Context;
import android.content.Intent;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.ConditionVariable;
import android.os.Handler;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.widget.MediaController;
import com.adsdk.sdk.Log;
import com.adsdk.sdk.video.MediaController;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;

public class SDKVideoView
extends SurfaceView
implements MediaController.MediaPlayerControl {
    private Uri mUri;
    private int mDuration;
    private static final int STATE_ERROR = -1;
    private static final int STATE_IDLE = 0;
    private static final int STATE_PREPARING = 1;
    private static final int STATE_PREPARED = 2;
    private static final int STATE_PLAYING = 3;
    private static final int STATE_PAUSED = 4;
    private static final int STATE_PLAYBACK_COMPLETED = 5;
    private int mCurrentState = 0;
    private int mTargetState = 0;
    private MediaPlayer mMediaPlayer = null;
    private int mWidth;
    private int mHeight;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private int mDisplayMode;
    private MediaController mMediaController;
    private MediaPlayer.OnCompletionListener mOnCompletionListener;
    private OnStartListener mOnStartListener;
    private MediaPlayer.OnPreparedListener mOnPreparedListener;
    private int mCurrentBufferPercentage;
    private MediaPlayer.OnErrorListener mOnErrorListener;
    private MediaPlayer.OnInfoListener mOnInfoListener;
    private int mSeekWhenPrepared;
    private boolean mPlayWhenSurfaceReady;
    private boolean mSurfaceReady = false;
    private Context mContext;
    private Thread mTimeEventThread;
    private Runnable mTimeEventRunnable;
    private ConditionVariable mTimeEventThreadDone = new ConditionVariable(false);
    private HashMap<Integer, Vector<OnTimeEventListener>> mTimeEventListeners = new HashMap();
    public Handler mHandler;
    MediaPlayer.OnVideoSizeChangedListener mSizeChangedListener = new MediaPlayer.OnVideoSizeChangedListener(){

        public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
            Log.d("SDKVideoView OnVideoSizeChangedListener");
        }
    };
    MediaPlayer.OnPreparedListener mPreparedListener = new MediaPlayer.OnPreparedListener(){

        public void onPrepared(MediaPlayer mp) {
            int seekToPosition;
            Log.d("SDKVideoView onPrepared");
            SDKVideoView.this.mCurrentState = 2;
            if (SDKVideoView.this.mOnPreparedListener != null) {
                SDKVideoView.this.mOnPreparedListener.onPrepared(SDKVideoView.this.mMediaPlayer);
            }
            if (SDKVideoView.this.mMediaController != null) {
                SDKVideoView.this.mMediaController.setEnabled(true);
            }
            if ((seekToPosition = SDKVideoView.this.mSeekWhenPrepared) != 0) {
                SDKVideoView.this.seekTo(seekToPosition);
            }
            if (!SDKVideoView.this.mSurfaceReady) {
                Log.d("SDKVideoView onPrepared surface not ready yet");
                return;
            }
            SDKVideoView.this.setVideoDisplaySize();
            if (SDKVideoView.this.mTargetState == 3) {
                SDKVideoView.this.start();
            } else if (!(SDKVideoView.this.isPlaying() || seekToPosition == 0 && SDKVideoView.this.getCurrentPosition() <= 0 || SDKVideoView.this.mMediaController == null)) {
                SDKVideoView.this.mMediaController.show(0);
            }
        }
    };
    private MediaPlayer.OnCompletionListener mCompletionListener = new MediaPlayer.OnCompletionListener(){

        public void onCompletion(MediaPlayer mp) {
            SDKVideoView.this.mCurrentState = 5;
            SDKVideoView.this.mTargetState = 5;
            if (SDKVideoView.this.mMediaController != null) {
                SDKVideoView.this.mMediaController.show(0);
            }
            if (SDKVideoView.this.mOnCompletionListener != null) {
                SDKVideoView.this.mOnCompletionListener.onCompletion(SDKVideoView.this.mMediaPlayer);
            }
        }
    };
    private MediaPlayer.OnErrorListener mErrorListener = new MediaPlayer.OnErrorListener(){

        public boolean onError(MediaPlayer mp, int framework_err, int impl_err) {
            Log.d("Error: " + framework_err + "," + impl_err);
            SDKVideoView.this.mCurrentState = -1;
            SDKVideoView.this.mTargetState = -1;
            if (SDKVideoView.this.mMediaController != null) {
                SDKVideoView.this.mMediaController.hide();
            }
            if (SDKVideoView.this.mOnErrorListener != null && SDKVideoView.this.mOnErrorListener.onError(SDKVideoView.this.mMediaPlayer, framework_err, impl_err)) {
                return true;
            }
            return true;
        }
    };
    private MediaPlayer.OnInfoListener mInfoListener = new MediaPlayer.OnInfoListener(){

        public boolean onInfo(MediaPlayer mp, int what, int extra) {
            Log.d("Info/Warning: " + what + "," + extra);
            if (SDKVideoView.this.mOnInfoListener != null && SDKVideoView.this.mOnInfoListener.onInfo(SDKVideoView.this.mMediaPlayer, what, extra)) {
                return true;
            }
            return true;
        }
    };
    private MediaPlayer.OnBufferingUpdateListener mBufferingUpdateListener = new MediaPlayer.OnBufferingUpdateListener(){

        public void onBufferingUpdate(MediaPlayer mp, int percent) {
            SDKVideoView.this.mCurrentBufferPercentage = percent;
        }
    };
    SurfaceHolder.Callback mSHCallback = new SurfaceHolder.Callback(){

        public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
            Log.d("SDKVideoView surfaceChanged");
            SDKVideoView.this.mSurfaceWidth = w;
            SDKVideoView.this.mSurfaceHeight = h;
            SDKVideoView.this.setVideoDisplaySize();
        }

        public void surfaceCreated(SurfaceHolder holder) {
            Log.d("Surface created");
            SDKVideoView.this.mSurfaceReady = true;
            if (SDKVideoView.this.mPlayWhenSurfaceReady) {
                SDKVideoView.this.openVideo();
            }
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            Log.d("Surface destroyed");
            SDKVideoView.this.mSurfaceReady = false;
            if (SDKVideoView.this.mMediaController != null) {
                SDKVideoView.this.mMediaController.hide();
            }
            SDKVideoView.this.release(true);
        }
    };

    public SDKVideoView(Context context, int width, int height, int displayMode) {
        super(context);
        this.mContext = context;
        this.mWidth = width;
        this.mHeight = height;
        this.mDisplayMode = displayMode;
        this.initVideoView();
    }

    public void destroy() {
        this.mTimeEventThreadDone.open();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = SDKVideoView.getDefaultSize((int)this.mVideoWidth, (int)widthMeasureSpec);
        int height = SDKVideoView.getDefaultSize((int)this.mVideoHeight, (int)heightMeasureSpec);
        if (this.mVideoWidth > 0 && this.mVideoHeight > 0) {
            if (this.mVideoWidth * height > width * this.mVideoHeight) {
                height = width * this.mVideoHeight / this.mVideoWidth;
            } else if (this.mVideoWidth * height < width * this.mVideoHeight) {
                width = height * this.mVideoWidth / this.mVideoHeight;
            }
        }
        this.setMeasuredDimension(width, height);
        Log.d("SDKVideoView onMeasure video size (" + this.mVideoWidth + "," + this.mVideoHeight + ") surface:(" + this.mSurfaceWidth + "," + this.mSurfaceHeight + ") Setting size:(" + width + "," + height + ")");
    }

    private void initVideoView() {
        this.mHandler = new Handler();
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
        this.mSurfaceWidth = 0;
        this.mSurfaceHeight = 0;
        this.mSurfaceReady = false;
        this.setVisibility(0);
        this.getHolder().addCallback(this.mSHCallback);
        this.getHolder().setType(3);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.requestFocus();
        this.mCurrentState = 0;
        this.mTargetState = 0;
    }

    public void setVideoPath(String path) {
        this.setVideoURI(Uri.parse((String)path));
    }

    public void setVideoURI(Uri uri) {
        this.mUri = uri;
        this.mSeekWhenPrepared = 0;
        this.openVideo();
    }

    public void stopPlayback() {
        if (this.mMediaPlayer != null) {
            if (this.mMediaPlayer.isPlaying()) {
                this.mMediaPlayer.stop();
            }
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            this.mCurrentState = 0;
            this.mTargetState = 0;
        }
    }

    private void openVideo() {
        if (this.mUri == null) {
            return;
        }
        this.mPlayWhenSurfaceReady = false;
        if (!this.mSurfaceReady) {
            this.mPlayWhenSurfaceReady = true;
            Log.d("Open Video not starting until surface created");
            return;
        }
        this.release(false);
        try {
            this.mMediaPlayer = new MediaPlayer();
            this.mMediaPlayer.setDisplay(this.getHolder());
            this.mMediaPlayer.setOnPreparedListener(this.mPreparedListener);
            this.mMediaPlayer.setOnVideoSizeChangedListener(this.mSizeChangedListener);
            this.mDuration = -1;
            this.mMediaPlayer.setOnCompletionListener(this.mCompletionListener);
            this.mMediaPlayer.setOnErrorListener(this.mErrorListener);
            this.mMediaPlayer.setOnBufferingUpdateListener(this.mBufferingUpdateListener);
            this.mMediaPlayer.setOnInfoListener(this.mInfoListener);
            this.mCurrentBufferPercentage = 0;
            this.mMediaPlayer.setDataSource(this.mContext, this.mUri);
            this.mMediaPlayer.setAudioStreamType(3);
            this.mMediaPlayer.setScreenOnWhilePlaying(true);
            this.mMediaPlayer.prepareAsync();
            this.mTimeEventRunnable = new Runnable(){

                @Override
                public void run() {
                    Log.d("Time Event Thread started");
                    do {
                        if (SDKVideoView.this.mMediaPlayer == null || SDKVideoView.this.mCurrentState != 3) continue;
                        try {
                            final int time = SDKVideoView.this.mMediaPlayer.getCurrentPosition() / 1000;
                            Vector listeners = (Vector)SDKVideoView.this.mTimeEventListeners.get(time);
                            if (listeners == null) continue;
                            int i = 0;
                            while (i < listeners.size()) {
                                final OnTimeEventListener l = (OnTimeEventListener)listeners.elementAt(i);
                                SDKVideoView.this.mHandler.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        l.onTimeEvent(time);
                                    }
                                });
                                ++i;
                            }
                            listeners.clear();
                        }
                        catch (Exception e) {
                            Log.e("Time Event Thread error" + e, e);
                        }
                    } while (!SDKVideoView.this.mTimeEventThreadDone.block(1000L));
                    Log.v("Time Event Thread stopped");
                }
            };
            this.mTimeEventThread = new Thread(this.mTimeEventRunnable);
            this.mTimeEventThread.start();
            this.mCurrentState = 1;
            this.attachMediaController();
        }
        catch (IOException ex) {
            Log.w("ADSDK", "Unable to open content: " + this.mUri, ex);
            this.mCurrentState = -1;
            this.mTargetState = -1;
            this.mErrorListener.onError(this.mMediaPlayer, 1, 0);
            return;
        }
        catch (IllegalArgumentException ex) {
            Log.w("ADSDK", "Unable to open content: " + this.mUri, ex);
            this.mCurrentState = -1;
            this.mTargetState = -1;
            this.mErrorListener.onError(this.mMediaPlayer, 1, 0);
            return;
        }
    }

    public void setMediaController(MediaController controller) {
        if (this.mMediaController != null) {
            this.mMediaController.hide();
        }
        this.mMediaController = controller;
        this.attachMediaController();
    }

    private void attachMediaController() {
        if (this.mMediaPlayer != null && this.mMediaController != null) {
            this.mMediaController.setMediaPlayer(this);
            this.mMediaController.setEnabled(this.isInPlaybackState());
        }
    }

    private void setVideoDisplaySize() {
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
        if (this.mMediaPlayer != null) {
            this.mVideoWidth = this.mMediaPlayer.getVideoWidth();
            this.mVideoHeight = this.mMediaPlayer.getVideoHeight();
        }
        Log.d("SDKVideoView setVideoDisplaySize View Size (" + this.mWidth + "," + this.mHeight + ") Video size (" + this.mVideoWidth + "," + this.mVideoHeight + ") surface:(" + this.mSurfaceWidth + "," + this.mSurfaceHeight + ")");
        if (this.mSurfaceReady && this.mVideoWidth > 0 && this.mVideoHeight > 0) {
            if (this.mDisplayMode == 1) {
                if (this.mVideoWidth * this.mHeight > this.mWidth * this.mVideoHeight) {
                    this.mHeight = this.mWidth * this.mVideoHeight / this.mVideoWidth;
                } else if (this.mVideoWidth * this.mHeight < this.mWidth * this.mVideoHeight) {
                    this.mWidth = this.mHeight * this.mVideoWidth / this.mVideoHeight;
                }
            }
            this.getHolder().setFixedSize(this.mWidth, this.mHeight);
        }
        this.getHolder().setFixedSize(this.mVideoWidth, this.mVideoHeight);
    }

    private void release(boolean cleartargetstate) {
        if (this.mMediaPlayer != null) {
            this.mCurrentState = 0;
            if (this.mTimeEventThread != null) {
                this.mTimeEventThreadDone.open();
                this.mTimeEventThread = null;
            }
            this.mMediaPlayer.reset();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            if (cleartargetstate) {
                this.mTargetState = 0;
            }
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.isInPlaybackState() && this.mMediaController != null && ev.getAction() == 0) {
            this.toggleMediaControlsVisiblity();
        }
        return false;
    }

    public boolean onTrackballEvent(MotionEvent ev) {
        if (this.isInPlaybackState() && this.mMediaController != null) {
            this.toggleMediaControlsVisiblity();
        }
        return false;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        boolean isKeyCodeSupported;
        boolean bl = isKeyCodeSupported = keyCode != 4 && keyCode != 24 && keyCode != 25 && keyCode != 82 && keyCode != 5 && keyCode != 6;
        if (this.isInPlaybackState() && isKeyCodeSupported && this.mMediaController != null) {
            if (keyCode == 79 || keyCode == 85) {
                if (this.mMediaPlayer.isPlaying()) {
                    this.pause();
                } else {
                    this.start();
                }
                return true;
            }
            if (keyCode == 86 && this.mMediaPlayer.isPlaying()) {
                this.pause();
            } else {
                this.toggleMediaControlsVisiblity();
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    private void toggleMediaControlsVisiblity() {
        if (this.mMediaController != null) {
            this.mMediaController.toggle();
        }
    }

    public void start() {
        this.mTargetState = 3;
        if (this.isInPlaybackState()) {
            Intent intent = new Intent("com.android.music.musicservicecommand");
            intent.putExtra("command", "pause");
            this.mContext.sendBroadcast(intent);
            this.mMediaPlayer.start();
            if (this.mMediaController != null) {
                this.mMediaController.onStart();
            }
            if (this.mCurrentState == 2 && this.mOnStartListener != null) {
                this.mOnStartListener.onVideoStart();
            }
            this.mCurrentState = 3;
        } else if (this.mMediaPlayer == null) {
            this.openVideo();
        }
    }

    public void pause() {
        if (this.isInPlaybackState() && this.mMediaPlayer.isPlaying()) {
            this.mMediaPlayer.pause();
            this.mCurrentState = 4;
            if (this.mMediaController != null) {
                this.mMediaController.onPause();
            }
        }
        this.mTargetState = 4;
    }

    public int getDuration() {
        if (this.isInPlaybackState()) {
            if (this.mDuration > 0) {
                return this.mDuration;
            }
            this.mDuration = this.mMediaPlayer.getDuration();
            return this.mDuration;
        }
        this.mDuration = -1;
        return this.mDuration;
    }

    public int getCurrentPosition() {
        if (this.isInPlaybackState()) {
            return this.mMediaPlayer.getCurrentPosition();
        }
        return 0;
    }

    public void seekTo(int msec) {
        if (this.isInPlaybackState()) {
            this.mMediaPlayer.seekTo(msec);
            this.mSeekWhenPrepared = 0;
        } else {
            this.mSeekWhenPrepared = msec;
        }
    }

    public boolean isPlaying() {
        return this.isInPlaybackState() && this.mMediaPlayer.isPlaying();
    }

    public int getBufferPercentage() {
        if (this.mMediaPlayer != null) {
            return this.mCurrentBufferPercentage;
        }
        return 0;
    }

    private boolean isInPlaybackState() {
        return this.mMediaPlayer != null && this.mCurrentState != -1 && this.mCurrentState != 0 && this.mCurrentState != 1;
    }

    public void setOnPreparedListener(MediaPlayer.OnPreparedListener l) {
        this.mOnPreparedListener = l;
    }

    public void setOnCompletionListener(MediaPlayer.OnCompletionListener l) {
        this.mOnCompletionListener = l;
    }

    public void setOnErrorListener(MediaPlayer.OnErrorListener l) {
        this.mOnErrorListener = l;
    }

    public void setOnInfoListener(MediaPlayer.OnInfoListener l) {
        this.mOnInfoListener = l;
    }

    public void setOnStartListener(OnStartListener l) {
        this.mOnStartListener = l;
    }

    public void setOnTimeEventListener(int time, OnTimeEventListener onTimeEventListener) {
        Vector<OnTimeEventListener> listeners = this.mTimeEventListeners.get(time);
        if (listeners == null) {
            listeners = new Vector();
            this.mTimeEventListeners.put(time, listeners);
        }
        listeners.add(onTimeEventListener);
    }

    protected void onDetachedFromWindow() {
        Log.i("Video view detached from Window");
        super.onDetachedFromWindow();
    }

    public boolean canPause() {
        return true;
    }

    public boolean canSeekBackward() {
        return false;
    }

    public boolean canSeekForward() {
        return true;
    }

    public static interface OnStartListener {
        public void onVideoStart();
    }

    public static interface OnTimeEventListener {
        public void onTimeEvent(int var1);
    }
}

