/*
 * Decompiled with CFR 0.152.
 */
package com.adsdk.sdk.video;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.VideoView;
import com.adsdk.sdk.AdManager;
import com.adsdk.sdk.Const;
import com.adsdk.sdk.Log;
import com.adsdk.sdk.Util;
import com.adsdk.sdk.video.InterstitialController;
import com.adsdk.sdk.video.InterstitialData;
import com.adsdk.sdk.video.MediaController;
import com.adsdk.sdk.video.ResourceManager;
import com.adsdk.sdk.video.RichMediaAd;
import com.adsdk.sdk.video.SDKVideoView;
import com.adsdk.sdk.video.TrackEvent;
import com.adsdk.sdk.video.TrackerService;
import com.adsdk.sdk.video.VideoData;
import com.adsdk.sdk.video.WebFrame;
import com.adsdk.sdk.video.WebViewClient;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class RichMediaActivity
extends Activity {
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_BROWSER = 0;
    public static final int TYPE_VIDEO = 1;
    public static final int TYPE_INTERSTITIAL = 2;
    private ResourceManager mResourceManager;
    private FrameLayout mRootLayout;
    private FrameLayout mVideoLayout;
    private FrameLayout mLoadingView;
    private FrameLayout mCustomView;
    private VideoView mCustomVideoView;
    private WebChromeClient.CustomViewCallback mCustomViewCallback;
    private SDKVideoView mVideoView;
    private WebFrame mOverlayView;
    private WebFrame mInterstitialView;
    private WebFrame mWebBrowserView;
    private MediaController mMediaController;
    private ImageView mSkipButton;
    private InterstitialController mInterstitialController;
    private RichMediaAd mAd;
    private VideoData mVideoData;
    private InterstitialData mInterstitialData;
    private Uri uri;
    private Timer mInterstitialLoadingTimer;
    private Timer mInterstitialAutocloseTimer;
    private Timer mInterstitialCanCloseTimer;
    private Timer mVideoTimeoutTimer;
    private int mWindowWidth;
    private int mWindowHeight;
    private int mVideoLastPosition;
    private int mVideoWidth;
    private int mVideoHeight;
    private boolean mCanClose;
    protected boolean mInterstitialAutocloseReset;
    private boolean mPageLoaded = false;
    private int mType;
    private int mEnterAnim;
    private int mExitAnim;
    private boolean mResult;
    DisplayMetrics metrics;
    int paddingArg = 5;
    int marginArg = 8;
    int skipButtonSizeLand = 50;
    int skipButtonSizePort = 40;
    private final SDKVideoView.OnTimeEventListener mOverlayShowListener = new SDKVideoView.OnTimeEventListener(){

        @Override
        public void onTimeEvent(int time) {
            Log.d("ADSDK", "RichMediaActivity mOverlayShowListener show after:" + time);
            if (RichMediaActivity.this.mOverlayView != null) {
                RichMediaActivity.this.mOverlayView.setVisibility(0);
                RichMediaActivity.this.mOverlayView.requestLayout();
            }
        }
    };
    private final View.OnClickListener mOverlayClickListener = new View.OnClickListener(){

        public void onClick(View arg0) {
            Log.d("ADSDK", "RichMediaActivity mOverlayClickListener");
            if (RichMediaActivity.this.mMediaController != null) {
                RichMediaActivity.this.mMediaController.toggle();
            }
        }
    };
    MediaPlayer.OnErrorListener mOnVideoErrorListener = new MediaPlayer.OnErrorListener(){

        public boolean onError(MediaPlayer mp, int what, int extra) {
            Log.w("Cannot play video/ Error: " + what + " Extra: " + extra);
            RichMediaActivity.this.finish();
            return false;
        }
    };
    protected int mTimeTest;
    MediaPlayer.OnInfoListener mOnVideoInfoListener = new MediaPlayer.OnInfoListener(){

        public boolean onInfo(MediaPlayer mp, int what, int extra) {
            Log.i("Info: " + what + " Extra: " + extra);
            if (what == 703) {
                RichMediaActivity.this.mTimeTest = RichMediaActivity.this.mVideoView.getCurrentPosition();
                new Handler().postDelayed(RichMediaActivity.this.mCheckProgressTask, 5000L);
            }
            return false;
        }
    };
    private Runnable mCheckProgressTask = new Runnable(){

        @Override
        public void run() {
            Log.w("Video playback is being checked");
            int test = RichMediaActivity.this.mVideoView.getCurrentPosition();
            if (test - RichMediaActivity.this.mTimeTest <= 1) {
                Log.w("Video playback too slow. Ending");
                RichMediaActivity.this.finish();
            } else {
                Log.w("Video playback has restarted");
            }
        }
    };
    MediaPlayer.OnPreparedListener mOnVideoPreparedListener = new MediaPlayer.OnPreparedListener(){

        public void onPrepared(MediaPlayer mp) {
            Log.d("ADSDK", "RichMediaActivity onPrepared MediaPlayer");
            if (RichMediaActivity.this.mVideoTimeoutTimer != null) {
                RichMediaActivity.this.mVideoTimeoutTimer.cancel();
                RichMediaActivity.this.mVideoTimeoutTimer = null;
            }
            if (RichMediaActivity.this.mLoadingView != null) {
                RichMediaActivity.this.mLoadingView.setVisibility(8);
            }
            if (((RichMediaActivity)RichMediaActivity.this).mVideoData.showNavigationBars) {
                RichMediaActivity.this.mMediaController.setVisibility(0);
            }
            RichMediaActivity.this.mVideoView.requestFocus();
        }
    };
    MediaPlayer.OnCompletionListener mOnVideoCompletionListener = new MediaPlayer.OnCompletionListener(){

        public void onCompletion(MediaPlayer mp) {
            Log.d("###########TRACKING END VIDEO");
            Vector<String> trackers = ((RichMediaActivity)RichMediaActivity.this).mVideoData.completeEvents;
            int i = 0;
            while (i < trackers.size()) {
                Log.d("Track url:" + trackers.get(i));
                TrackEvent event = new TrackEvent();
                event.url = trackers.get(i);
                event.timestamp = System.currentTimeMillis();
                TrackerService.requestTrack(event);
                ++i;
            }
            if (RichMediaActivity.this.mType == 1 && RichMediaActivity.this.mAd.getType() == 3) {
                Intent intent = new Intent((Context)RichMediaActivity.this, RichMediaActivity.class);
                intent.putExtra("RICH_AD_DATA", (Serializable)RichMediaActivity.this.mAd);
                intent.putExtra("RICH_AD_TYPE", 2);
                try {
                    RichMediaActivity.this.startActivity(intent);
                    RichMediaActivity.setActivityAnimation(RichMediaActivity.this, RichMediaActivity.this.mEnterAnim, RichMediaActivity.this.mExitAnim);
                }
                catch (Exception e) {
                    Log.e("Cannot start Rich Ad activity:" + e, e);
                }
            }
            RichMediaActivity.this.mResult = true;
            RichMediaActivity.this.setResult(-1);
            RichMediaActivity.this.finish();
        }
    };
    SDKVideoView.OnStartListener mOnVideoStartListener = new SDKVideoView.OnStartListener(){

        @Override
        public void onVideoStart() {
            Log.d("###########TRACKING START VIDEO");
            Vector<String> trackers = ((RichMediaActivity)RichMediaActivity.this).mVideoData.startEvents;
            int i = 0;
            while (i < trackers.size()) {
                Log.d("Track url:" + trackers.get(i));
                TrackEvent event = new TrackEvent();
                event.url = trackers.get(i);
                event.timestamp = System.currentTimeMillis();
                TrackerService.requestTrack(event);
                ++i;
            }
        }
    };
    MediaController.OnPauseListener mOnVideoPauseListener = new MediaController.OnPauseListener(){

        @Override
        public void onVideoPause() {
            Log.d("###########TRACKING PAUSE VIDEO");
            Vector<String> trackers = ((RichMediaActivity)RichMediaActivity.this).mVideoData.pauseEvents;
            int i = 0;
            while (i < trackers.size()) {
                Log.d("Track url:" + trackers.get(i));
                TrackEvent event = new TrackEvent();
                event.url = trackers.get(i);
                event.timestamp = System.currentTimeMillis();
                TrackerService.requestTrack(event);
                ++i;
            }
        }
    };
    MediaController.OnUnpauseListener mOnVideoUnpauseListener = new MediaController.OnUnpauseListener(){

        @Override
        public void onVideoUnpause() {
            Log.d("###########TRACKING UNPAUSE VIDEO");
            Vector<String> trackers = ((RichMediaActivity)RichMediaActivity.this).mVideoData.unpauseEvents;
            int i = 0;
            while (i < trackers.size()) {
                Log.d("Track url:" + trackers.get(i));
                TrackEvent event = new TrackEvent();
                event.url = trackers.get(i);
                event.timestamp = System.currentTimeMillis();
                TrackerService.requestTrack(event);
                ++i;
            }
        }
    };
    SDKVideoView.OnTimeEventListener mOnVideoTimeEventListener = new SDKVideoView.OnTimeEventListener(){

        @Override
        public void onTimeEvent(int time) {
            Log.d("###########TRACKING TIME VIDEO:" + time);
            Vector<String> trackers = ((RichMediaActivity)RichMediaActivity.this).mVideoData.timeTrackingEvents.get(time);
            if (trackers != null) {
                int i = 0;
                while (i < trackers.size()) {
                    Log.d("Track url:" + trackers.get(i));
                    TrackEvent event = new TrackEvent();
                    event.url = trackers.get(i);
                    event.timestamp = System.currentTimeMillis();
                    TrackerService.requestTrack(event);
                    ++i;
                }
            }
        }
    };
    SDKVideoView.OnTimeEventListener mOnVideoCanCloseEventListener = new SDKVideoView.OnTimeEventListener(){

        @Override
        public void onTimeEvent(int time) {
            Log.d("###########CAN CLOSE VIDEO:" + time);
            RichMediaActivity.this.mCanClose = true;
            if (((RichMediaActivity)RichMediaActivity.this).mVideoData.showSkipButton && RichMediaActivity.this.mSkipButton != null) {
                RichMediaActivity.this.mSkipButton.setImageDrawable(RichMediaActivity.this.mResourceManager.getResource((Context)RichMediaActivity.this, -18));
                RichMediaActivity.this.mSkipButton.setVisibility(0);
            }
        }
    };
    View.OnClickListener mOnVideoSkipListener = new View.OnClickListener(){

        public void onClick(View v) {
            Log.v("###########TRACKING SKIP VIDEO");
            Vector<String> trackers = ((RichMediaActivity)RichMediaActivity.this).mVideoData.skipEvents;
            int i = 0;
            while (i < trackers.size()) {
                Log.d("Track url:" + trackers.get(i));
                TrackEvent event = new TrackEvent();
                event.url = trackers.get(i);
                event.timestamp = System.currentTimeMillis();
                TrackerService.requestTrack(event);
                ++i;
            }
            RichMediaActivity.this.mResult = true;
            RichMediaActivity.this.setResult(-1);
            RichMediaActivity.this.finish();
        }
    };
    MediaController.OnReplayListener mOnVideoReplayListener = new MediaController.OnReplayListener(){

        @Override
        public void onVideoReplay() {
            Log.d("###########TRACKING REPLAY VIDEO");
            Vector<String> trackers = ((RichMediaActivity)RichMediaActivity.this).mVideoData.replayEvents;
            int i = 0;
            while (i < trackers.size()) {
                Log.d("Track url:" + trackers.get(i));
                TrackEvent event = new TrackEvent();
                event.url = trackers.get(i);
                event.timestamp = System.currentTimeMillis();
                TrackerService.requestTrack(event);
                ++i;
            }
        }
    };
    private final View.OnClickListener mInterstitialClickListener = new View.OnClickListener(){

        public void onClick(View arg0) {
            Log.d("ADSDK", "RichMediaActivity mInterstitialClickListener");
            if (RichMediaActivity.this.mInterstitialController != null) {
                RichMediaActivity.this.mInterstitialController.toggle();
                RichMediaActivity.this.mInterstitialController.resetAutoclose();
            }
        }
    };
    View.OnClickListener mOnInterstitialSkipListener = new View.OnClickListener(){

        public void onClick(View v) {
            Log.v("###########TRACKING SKIP INTERSTITIAL");
            RichMediaActivity.this.mResult = true;
            RichMediaActivity.this.setResult(-1);
            RichMediaActivity.this.finish();
        }
    };
    InterstitialController.OnResetAutocloseListener mOnResetAutocloseListener = new InterstitialController.OnResetAutocloseListener(){

        @Override
        public void onResetAutoclose() {
            Log.v("###########RESET AUTOCLOSE INTERSTITIAL");
            RichMediaActivity.this.mInterstitialAutocloseReset = true;
            if (RichMediaActivity.this.mInterstitialAutocloseTimer != null) {
                RichMediaActivity.this.mInterstitialAutocloseTimer.cancel();
                RichMediaActivity.this.mInterstitialAutocloseTimer = null;
            }
        }
    };
    WebViewClient.OnPageLoadedListener mOnInterstitialLoadedListener = new WebViewClient.OnPageLoadedListener(){

        @Override
        public void onPageLoaded() {
            Log.v("onPageLoaded");
            if (RichMediaActivity.this.mInterstitialData != null && ((RichMediaActivity)RichMediaActivity.this).mInterstitialData.autoclose > 0 && RichMediaActivity.this.mInterstitialAutocloseTimer == null && !RichMediaActivity.this.mInterstitialAutocloseReset) {
                InterstitialAutocloseTask autocloseTask = new InterstitialAutocloseTask(RichMediaActivity.this);
                RichMediaActivity.this.mInterstitialAutocloseTimer = new Timer();
                RichMediaActivity.this.mInterstitialAutocloseTimer.schedule((TimerTask)autocloseTask, ((RichMediaActivity)RichMediaActivity.this).mInterstitialData.autoclose * 1000);
                Log.v("onPageLoaded mInterstitialAutocloseTimer");
            }
            if (RichMediaActivity.this.mInterstitialData != null && ((RichMediaActivity)RichMediaActivity.this).mInterstitialData.showSkipButtonAfter > 0) {
                if (RichMediaActivity.this.mInterstitialCanCloseTimer == null) {
                    CanSkipTask skipTask = new CanSkipTask(RichMediaActivity.this);
                    RichMediaActivity.this.mInterstitialCanCloseTimer = new Timer();
                    RichMediaActivity.this.mInterstitialCanCloseTimer.schedule((TimerTask)skipTask, ((RichMediaActivity)RichMediaActivity.this).mInterstitialData.showSkipButtonAfter * 1000);
                    Log.v("onPageLoaded mInterstitialCanCloseTimer");
                }
            } else {
                RichMediaActivity.this.mCanClose = true;
            }
            if (RichMediaActivity.this.mInterstitialLoadingTimer != null) {
                RichMediaActivity.this.mInterstitialLoadingTimer.cancel();
                RichMediaActivity.this.mInterstitialLoadingTimer = null;
            }
            RichMediaActivity.this.mPageLoaded = true;
            RichMediaActivity.this.mInterstitialController.pageLoaded();
        }
    };
    WebViewClient.OnPageLoadedListener mOnWebBrowserLoadedListener = new WebViewClient.OnPageLoadedListener(){

        @Override
        public void onPageLoaded() {
            RichMediaActivity.this.mPageLoaded = true;
        }
    };
    private ResourceHandler mHandler;

    public static void setActivityAnimation(Activity activity, int in, int out) {
        try {
            activity.overridePendingTransition(in, out);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 100: {
                switch (msg.arg1) {
                    case -18: {
                        if (this.mSkipButton == null) return;
                        if (this.mResourceManager.containsResource(-18)) {
                            this.mSkipButton.setImageDrawable(this.mResourceManager.getResource((Context)this, -18));
                            return;
                        }
                        this.mSkipButton.setImageDrawable(this.mResourceManager.getResource((Context)this, -18));
                    }
                }
                return;
            }
        }
    }

    public void finish() {
        if (this.mAd != null) {
            Log.d("Finish Activity type:" + this.mType + " ad Type:" + this.mAd.getType());
            switch (this.mType) {
                case 1: {
                    if (this.mAd.getType() == 5) {
                        AdManager.closeRunningAd(this.mAd, this.mResult);
                        break;
                    }
                    if (this.mAd.getType() != 3 || this.mResult) break;
                    AdManager.closeRunningAd(this.mAd, this.mResult);
                    break;
                }
                case 2: {
                    if (this.mAd.getType() != 6 && this.mAd.getType() != 3 && this.mAd.getType() != 4) break;
                    AdManager.closeRunningAd(this.mAd, this.mResult);
                }
            }
        }
        super.finish();
        RichMediaActivity.setActivityAnimation(this, this.mEnterAnim, this.mExitAnim);
    }

    public int getDipSize(int argSize) {
        return (int)TypedValue.applyDimension((int)1, (float)argSize, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public FrameLayout getRootLayout() {
        return this.mRootLayout;
    }

    public void goBack() {
        if (this.mCustomView != null) {
            Log.d("Closing custom view on back key pressed");
            this.onHideCustomView();
            return;
        }
        switch (this.mType) {
            case 1: {
                if (!this.mCanClose) break;
                this.finish();
                break;
            }
            case 2: {
                if (this.mInterstitialView.canGoBack()) {
                    this.mInterstitialView.goBack();
                    break;
                }
                if (!this.mCanClose) break;
                this.mResult = true;
                this.setResult(-1);
                this.finish();
                break;
            }
            case 0: {
                if (this.mWebBrowserView.canGoBack()) {
                    this.mWebBrowserView.goBack();
                    break;
                }
                this.finish();
            }
        }
    }

    private void initInterstitialView() {
        this.mInterstitialData = this.mAd.getInterstitial();
        this.mInterstitialAutocloseReset = false;
        this.setRequestedOrientation(this.mInterstitialData.orientation);
        FrameLayout layout = new FrameLayout((Context)this);
        this.mInterstitialView = new WebFrame(this, true, false, false);
        this.mInterstitialView.setBackgroundColor(0);
        this.mInterstitialView.setOnPageLoadedListener(this.mOnInterstitialLoadedListener);
        this.mInterstitialController = new InterstitialController((Context)this, this.mInterstitialData);
        this.mInterstitialController.setBrowser(this.mInterstitialView);
        this.mInterstitialController.setBrowserView((View)this.mInterstitialView);
        this.mInterstitialController.setOnResetAutocloseListener(this.mOnResetAutocloseListener);
        layout.addView((View)this.mInterstitialController, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
        if (this.mInterstitialData.showNavigationBars) {
            this.mInterstitialController.show(0);
        }
        if (this.mInterstitialData.showSkipButton) {
            int margin;
            this.mSkipButton = new ImageView((Context)this);
            this.mSkipButton.setAdjustViewBounds(false);
            FrameLayout.LayoutParams params = null;
            int buttonSize = (int)TypedValue.applyDimension((int)1, (float)this.skipButtonSizeLand, (DisplayMetrics)this.getResources().getDisplayMetrics());
            int size = Math.min(this.getResources().getDisplayMetrics().widthPixels, this.getResources().getDisplayMetrics().heightPixels);
            buttonSize = (int)((double)size * 0.1);
            params = new FrameLayout.LayoutParams(buttonSize, buttonSize, 53);
            if (this.mInterstitialData.orientation == 1) {
                params.topMargin = margin = (int)TypedValue.applyDimension((int)1, (float)8.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                params.rightMargin = margin;
            } else {
                params.topMargin = margin = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                params.rightMargin = margin;
            }
            if (this.mInterstitialData.skipButtonImage != null && this.mInterstitialData.skipButtonImage.length() > 0) {
                this.mSkipButton.setBackgroundDrawable(null);
                this.mResourceManager.fetchResource((Context)this, this.mInterstitialData.skipButtonImage, -18);
            } else {
                this.mSkipButton.setImageDrawable(this.mResourceManager.getResource((Context)this, -18));
            }
            this.mSkipButton.setOnClickListener(this.mOnInterstitialSkipListener);
            if (this.mInterstitialData.showSkipButtonAfter > 0) {
                this.mCanClose = false;
                this.mSkipButton.setVisibility(8);
                if (this.mInterstitialLoadingTimer == null) {
                    InterstitialLoadingTimeoutTask loadingTimeoutTask = new InterstitialLoadingTimeoutTask();
                    this.mInterstitialLoadingTimer = new Timer();
                    this.mInterstitialLoadingTimer.schedule((TimerTask)loadingTimeoutTask, 10000L);
                }
            } else {
                this.mCanClose = true;
                this.mSkipButton.setVisibility(0);
            }
            layout.addView((View)this.mSkipButton, (ViewGroup.LayoutParams)params);
        } else {
            this.mCanClose = false;
        }
        this.mInterstitialView.setOnClickListener(this.mInterstitialClickListener);
        this.mRootLayout.addView((View)layout);
        switch (this.mInterstitialData.interstitialType) {
            case 1: {
                this.mInterstitialView.setMarkup(this.mInterstitialData.interstitialMarkup);
                break;
            }
            case 0: {
                this.mInterstitialView.loadUrl(this.mInterstitialData.interstitialUrl);
            }
        }
        Log.i(this.mInterstitialView.getWebView().getSettings().getUserAgentString());
    }

    private void initRootLayout() {
        this.mRootLayout = new FrameLayout((Context)this);
        this.mRootLayout.setBackgroundColor(-16777216);
    }

    private void initVideoView() {
        int size;
        this.mVideoData = this.mAd.getVideo();
        this.setRequestedOrientation(this.mVideoData.orientation);
        if (this.mVideoData.orientation == 0) {
            if (this.mWindowWidth < this.mWindowHeight) {
                size = this.mWindowWidth;
                this.mWindowWidth = this.mWindowHeight;
                this.mWindowHeight = size;
            }
        } else if (this.mWindowHeight < this.mWindowWidth) {
            size = this.mWindowHeight;
            this.mWindowHeight = this.mWindowWidth;
            this.mWindowWidth = size;
        }
        this.mVideoWidth = this.mVideoData.width;
        this.mVideoHeight = this.mVideoData.height;
        if (this.mVideoWidth <= 0) {
            this.mVideoWidth = this.mWindowWidth;
            this.mVideoHeight = this.mWindowHeight;
        } else {
            DisplayMetrics m = this.getResources().getDisplayMetrics();
            this.mVideoWidth = (int)TypedValue.applyDimension((int)1, (float)this.mVideoWidth, (DisplayMetrics)m);
            this.mVideoHeight = (int)TypedValue.applyDimension((int)1, (float)this.mVideoHeight, (DisplayMetrics)m);
            if (this.mVideoWidth > this.mWindowWidth) {
                this.mVideoWidth = this.mWindowWidth;
            }
            if (this.mVideoHeight > this.mWindowHeight) {
                this.mVideoHeight = this.mWindowHeight;
            }
        }
        Log.d("Video size (" + this.mVideoWidth + "," + this.mVideoHeight + ")");
        this.mVideoLayout = new FrameLayout((Context)this);
        this.mVideoView = new SDKVideoView((Context)this, this.mVideoWidth, this.mVideoHeight, this.mVideoData.display);
        this.mVideoLayout.addView((View)this.mVideoView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
        if (this.mVideoData.showHtmlOverlay) {
            this.mOverlayView = new WebFrame(this, false, false, false);
            this.mOverlayView.setEnableZoom(false);
            this.mOverlayView.setOnClickListener(this.mOverlayClickListener);
            this.mOverlayView.setBackgroundColor(0);
            if (this.mVideoData.showHtmlOverlayAfter > 0) {
                this.mOverlayView.setVisibility(8);
                this.mVideoView.setOnTimeEventListener(this.mVideoData.showHtmlOverlayAfter, this.mOverlayShowListener);
            }
            if (this.mVideoData.htmlOverlayType == 0) {
                this.mOverlayView.loadUrl(this.mVideoData.htmlOverlayUrl);
            } else {
                this.mOverlayView.setMarkup(this.mVideoData.htmlOverlayMarkup);
            }
            FrameLayout.LayoutParams overlayParams = new FrameLayout.LayoutParams(-1, -1);
            if (this.mVideoData.showBottomNavigationBar && this.mVideoData.showTopNavigationBar) {
                overlayParams.bottomMargin = (int)((double)this.mWindowWidth * 0.11875);
                overlayParams.topMargin = (int)((double)this.mWindowWidth * 0.11875);
                overlayParams.gravity = 17;
            } else if (this.mVideoData.showBottomNavigationBar && !this.mVideoData.showTopNavigationBar) {
                overlayParams.bottomMargin = (int)((double)this.mWindowWidth * 0.11875);
                overlayParams.gravity = 48;
            } else if (this.mVideoData.showTopNavigationBar && !this.mVideoData.showBottomNavigationBar) {
                overlayParams.topMargin = (int)((double)this.mWindowWidth * 0.11875);
                overlayParams.gravity = 80;
            }
            this.mVideoLayout.addView((View)this.mOverlayView, (ViewGroup.LayoutParams)overlayParams);
        }
        this.mMediaController = new MediaController((Context)this, this.mVideoData);
        this.mVideoView.setMediaController(this.mMediaController);
        if (this.mVideoData.showNavigationBars) {
            this.mMediaController.toggle();
        }
        if (!this.mVideoData.pauseEvents.isEmpty()) {
            this.mMediaController.setOnPauseListener(this.mOnVideoPauseListener);
        }
        if (!this.mVideoData.unpauseEvents.isEmpty()) {
            this.mMediaController.setOnUnpauseListener(this.mOnVideoUnpauseListener);
        }
        if (!this.mVideoData.replayEvents.isEmpty()) {
            this.mMediaController.setOnReplayListener(this.mOnVideoReplayListener);
        }
        this.mVideoLayout.addView((View)this.mMediaController, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 7));
        if (this.mVideoData.showSkipButton) {
            int margin;
            this.mSkipButton = new ImageView((Context)this);
            this.mSkipButton.setAdjustViewBounds(false);
            FrameLayout.LayoutParams params = null;
            int buttonSize = (int)TypedValue.applyDimension((int)1, (float)this.skipButtonSizeLand, (DisplayMetrics)this.getResources().getDisplayMetrics());
            int size2 = Math.min(this.getResources().getDisplayMetrics().widthPixels, this.getResources().getDisplayMetrics().heightPixels);
            buttonSize = (int)((double)size2 * 0.09);
            params = new FrameLayout.LayoutParams(buttonSize, buttonSize, 53);
            if (this.mVideoData.orientation == 1) {
                params.topMargin = margin = (int)TypedValue.applyDimension((int)1, (float)8.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                params.rightMargin = margin;
            } else {
                params.topMargin = margin = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                params.rightMargin = margin;
            }
            if (this.mVideoData.skipButtonImage != null && this.mVideoData.skipButtonImage.length() > 0) {
                this.mResourceManager.fetchResource((Context)this, this.mVideoData.skipButtonImage, -18);
            } else {
                this.mSkipButton.setImageDrawable(this.mResourceManager.getResource((Context)this, -18));
            }
            this.mSkipButton.setOnClickListener(this.mOnVideoSkipListener);
            if (this.mVideoData.showSkipButtonAfter > 0) {
                this.mCanClose = false;
                this.mSkipButton.setVisibility(8);
            } else {
                this.mCanClose = true;
                this.mSkipButton.setVisibility(0);
            }
            this.mVideoLayout.addView((View)this.mSkipButton, (ViewGroup.LayoutParams)params);
        } else {
            this.mCanClose = false;
        }
        if (this.mVideoData.showSkipButtonAfter > 0) {
            this.mVideoView.setOnTimeEventListener(this.mVideoData.showSkipButtonAfter, this.mOnVideoCanCloseEventListener);
        }
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2, 17);
        this.mLoadingView = new FrameLayout((Context)this);
        TextView loadingText = new TextView((Context)this);
        loadingText.setText(Const.LOADING);
        this.mLoadingView.addView((View)loadingText, (ViewGroup.LayoutParams)params);
        this.mVideoLayout.addView((View)this.mLoadingView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
        this.mVideoView.setOnPreparedListener(this.mOnVideoPreparedListener);
        this.mVideoView.setOnCompletionListener(this.mOnVideoCompletionListener);
        this.mVideoView.setOnErrorListener(this.mOnVideoErrorListener);
        this.mVideoView.setOnInfoListener(this.mOnVideoInfoListener);
        if (!this.mVideoData.startEvents.isEmpty()) {
            this.mVideoView.setOnStartListener(this.mOnVideoStartListener);
        }
        if (!this.mVideoData.timeTrackingEvents.isEmpty()) {
            Set<Integer> keys = this.mVideoData.timeTrackingEvents.keySet();
            for (int key : keys) {
                this.mVideoView.setOnTimeEventListener(key, this.mOnVideoTimeEventListener);
            }
        }
        this.mVideoLastPosition = 0;
        String path = this.mVideoData.videoUrl;
        this.mVideoView.setVideoPath(path);
    }

    private void initWebBrowserView(boolean showExit) {
        this.mWebBrowserView = new WebFrame(this, true, true, showExit);
        this.mWebBrowserView.setOnPageLoadedListener(this.mOnWebBrowserLoadedListener);
        this.mRootLayout.addView((View)this.mWebBrowserView);
    }

    public void navigate(String clickUrl) {
        switch (this.mType) {
            case 0: {
                this.mWebBrowserView.loadUrl(clickUrl);
                break;
            }
            case 2: {
                this.mInterstitialView.loadUrl(clickUrl);
                break;
            }
            default: {
                Intent intent = new Intent((Context)this, RichMediaActivity.class);
                intent.setData(Uri.parse((String)clickUrl));
                this.startActivity(intent);
            }
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        Log.d("RichMediaActivity onConfigurationChanged");
    }

    public void onCreate(Bundle icicle) {
        Log.d("RichMediaActivity onCreate");
        super.onCreate(icicle);
        this.mResult = false;
        this.mPageLoaded = false;
        this.setResult(0);
        Window win = this.getWindow();
        win.setFlags(1024, 1024);
        this.requestWindowFeature(1);
        win.addFlags(512);
        Display display = this.getWindowManager().getDefaultDisplay();
        this.metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)this.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(this.metrics);
        this.mWindowWidth = display.getWidth();
        this.mWindowHeight = display.getHeight();
        win.clearFlags(512);
        Log.d("RichMediaActivity Window Size:(" + this.mWindowWidth + "," + this.mWindowHeight + ")");
        this.setVolumeControlStream(3);
        this.mType = -1;
        Intent intent = this.getIntent();
        Bundle extras = intent.getExtras();
        if (extras == null || extras.getSerializable("RICH_AD_DATA") == null) {
            this.uri = intent.getData();
            if (this.uri == null) {
                Log.d("url is null so do not load anything");
                this.finish();
                return;
            }
            this.mType = 0;
        } else {
            this.requestWindowFeature(1);
        }
        this.mHandler = new ResourceHandler(this);
        this.mResourceManager = new ResourceManager((Context)this, this.mHandler);
        this.initRootLayout();
        if (this.mType == 0) {
            this.initWebBrowserView(true);
            this.mWebBrowserView.loadUrl(this.uri.toString());
            this.mEnterAnim = Util.getEnterAnimation(1);
            this.mExitAnim = Util.getExitAnimation(1);
        } else {
            this.mAd = (RichMediaAd)extras.getSerializable("RICH_AD_DATA");
            this.mEnterAnim = Util.getEnterAnimation(this.mAd.getAnimation());
            this.mExitAnim = Util.getExitAnimation(this.mAd.getAnimation());
            this.mCanClose = false;
            this.mType = extras.getInt("RICH_AD_TYPE", -1);
            if (this.mType == -1) {
                switch (this.mAd.getType()) {
                    case 3: 
                    case 5: {
                        this.mType = 1;
                        break;
                    }
                    case 4: 
                    case 6: {
                        this.mType = 2;
                    }
                }
            }
            switch (this.mType) {
                case 1: {
                    Log.v("Type video");
                    this.initVideoView();
                    break;
                }
                case 2: {
                    Log.v("Type interstitial");
                    this.initInterstitialView();
                }
            }
        }
        this.setContentView((View)this.mRootLayout);
        Log.d("RichMediaActivity onCreate done");
    }

    protected void onDestroy() {
        this.mMediaController = null;
        this.mResourceManager.releaseInstance();
        if (this.mVideoView != null) {
            this.mVideoView.destroy();
        }
        Log.d("RichMediaActivity onDestroy");
        super.onDestroy();
        Log.d("RichMediaActivity onDestroy done");
    }

    public void onHideCustomView() {
        Log.d("onHideCustomView Hidding Custom View");
        if (this.mCustomView != null) {
            this.mCustomView.setVisibility(8);
            this.mCustomView = null;
            if (this.mCustomVideoView != null) {
                try {
                    Log.d("onHideCustomView stop video");
                    this.mCustomVideoView.stopPlayback();
                }
                catch (Exception e) {
                    Log.d("Couldn't stop custom video view");
                }
                this.mCustomVideoView = null;
            }
        }
        Log.d("onHideCustomView calling callback");
        this.mCustomViewCallback.onCustomViewHidden();
        this.mRootLayout.setVisibility(0);
        this.setContentView((View)this.mRootLayout);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            this.goBack();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    protected void onPause() {
        Log.d("RichMediaActivity onPause");
        super.onPause();
        switch (this.mType) {
            case 1: {
                this.mVideoLastPosition = this.mVideoView.getCurrentPosition();
                this.mVideoView.stopPlayback();
                this.mRootLayout.removeView((View)this.mVideoLayout);
                if (this.mVideoTimeoutTimer == null) break;
                this.mVideoTimeoutTimer.cancel();
                this.mVideoTimeoutTimer = null;
                break;
            }
            case 2: {
                if (this.mInterstitialLoadingTimer != null) {
                    this.mInterstitialLoadingTimer.cancel();
                    this.mInterstitialLoadingTimer = null;
                }
                if (this.mInterstitialAutocloseTimer != null) {
                    this.mInterstitialAutocloseTimer.cancel();
                    this.mInterstitialAutocloseTimer = null;
                }
                if (this.mInterstitialCanCloseTimer == null) break;
                this.mInterstitialCanCloseTimer.cancel();
                this.mInterstitialCanCloseTimer = null;
            }
        }
        Log.d("RichMediaActivity onPause done");
    }

    protected void onResume() {
        Log.d("RichMediaActivity onResume");
        super.onResume();
        switch (this.mType) {
            case 1: {
                this.mRootLayout.addView((View)this.mVideoLayout);
                this.mVideoView.seekTo(this.mVideoLastPosition);
                this.mVideoView.start();
                if (this.mVideoTimeoutTimer != null) break;
                VideoTimeoutTask autocloseTask = new VideoTimeoutTask(this);
                this.mVideoTimeoutTimer = new Timer();
                this.mVideoTimeoutTimer.schedule((TimerTask)autocloseTask, 1200000L);
                break;
            }
            case 2: {
                switch (this.mInterstitialData.interstitialType) {
                    case 1: {
                        if (this.mPageLoaded) break;
                        this.mInterstitialView.setMarkup(this.mInterstitialData.interstitialMarkup);
                        break;
                    }
                    case 0: {
                        if (this.mPageLoaded) break;
                        this.mInterstitialView.loadUrl(this.mInterstitialData.interstitialUrl);
                    }
                }
                break;
            }
        }
        Log.d("RichMediaActivity onResume done");
    }

    public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
        Log.d(" onShowCustomView");
        if (view instanceof FrameLayout) {
            this.mCustomView = (FrameLayout)view;
            this.mCustomViewCallback = callback;
            if (this.mCustomView.getFocusedChild() instanceof VideoView) {
                Log.d(" onShowCustomView Starting Video View");
                this.mCustomVideoView = (VideoView)this.mCustomView.getFocusedChild();
                this.mCustomVideoView.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                    public void onCompletion(MediaPlayer mp) {
                        Log.d(" onCompletion Video");
                        RichMediaActivity.this.onHideCustomView();
                    }
                });
                this.mCustomVideoView.start();
            }
            this.mRootLayout.setVisibility(8);
            this.mCustomView.setVisibility(0);
            this.setContentView((View)this.mCustomView);
        }
    }

    public void playVideo() {
        Log.d("RichMediaActivity play video:" + this.mType);
        switch (this.mType) {
            case 1: {
                if (this.mMediaController == null) break;
                this.mMediaController.replay();
                break;
            }
            case 2: {
                if (this.mAd.getType() != 4) break;
                Log.d("RichMediaActivity launch video");
                Intent intent = new Intent((Context)this, RichMediaActivity.class);
                intent.putExtra("RICH_AD_DATA", (Serializable)this.mAd);
                intent.putExtra("RICH_AD_TYPE", 1);
                try {
                    this.startActivity(intent);
                    RichMediaActivity.setActivityAnimation(this, this.mEnterAnim, this.mExitAnim);
                    this.mResult = true;
                    this.setResult(-1);
                    break;
                }
                catch (Exception e) {
                    Log.e("ADSDK", "Cannot start Rich Ad activity:" + e, e);
                }
            }
        }
    }

    public void replayVideo() {
        if (this.mMediaController != null) {
            this.mMediaController.replay();
        }
    }

    class CanSkipTask
    extends TimerTask {
        private final RichMediaActivity mActivity;

        public CanSkipTask(RichMediaActivity activity) {
            this.mActivity = activity;
        }

        @Override
        public void run() {
            Log.v("###########TRACKING CAN CLOSE INTERSTITIAL");
            this.mActivity.mCanClose = true;
            if (this.mActivity.mSkipButton != null) {
                this.mActivity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        CanSkipTask.this.mActivity.mSkipButton.setVisibility(0);
                    }
                });
            }
        }
    }

    class InterstitialAutocloseTask
    extends TimerTask {
        private final Activity mActivity;

        public InterstitialAutocloseTask(Activity activity) {
            this.mActivity = activity;
        }

        @Override
        public void run() {
            Log.v("###########TRACKING INTERSTITIAL AUTOCLOSE");
            RichMediaActivity.this.mResult = true;
            this.mActivity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    RichMediaActivity.this.setResult(-1);
                    RichMediaActivity.this.finish();
                }
            });
        }
    }

    class InterstitialLoadingTimeoutTask
    extends TimerTask {
        InterstitialLoadingTimeoutTask() {
        }

        @Override
        public void run() {
            Log.v("ADSDK", "###########TRACKING INTERSTITIAL LOADING TIMEOUT");
            RichMediaActivity.this.mCanClose = true;
            RichMediaActivity.this.mInterstitialController.pageLoaded();
        }
    }

    static class ResourceHandler
    extends Handler {
        WeakReference<RichMediaActivity> richMediaActivity;

        public ResourceHandler(RichMediaActivity activity) {
            this.richMediaActivity = new WeakReference<RichMediaActivity>(activity);
        }

        public void handleMessage(Message msg) {
            RichMediaActivity wRichMediaActivity = (RichMediaActivity)((Object)this.richMediaActivity.get());
            if (wRichMediaActivity != null) {
                wRichMediaActivity.handleMessage(msg);
            }
        }
    }

    class VideoTimeoutTask
    extends TimerTask {
        private final Activity mActivity;

        public VideoTimeoutTask(Activity activity) {
            this.mActivity = activity;
        }

        @Override
        public void run() {
            Log.v("###########TRACKING VIDEO TIMEOUT");
            this.mActivity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    VideoTimeoutTask.this.mActivity.finish();
                }
            });
        }
    }
}

