/*
 * Decompiled with CFR 0.152.
 */
package com.adsdk.sdk.video;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.adsdk.sdk.Log;
import com.adsdk.sdk.video.AspectRatioImageViewWidth;
import com.adsdk.sdk.video.NavIconData;
import com.adsdk.sdk.video.RichMediaActivity;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;

public class NavIcon
extends AspectRatioImageViewWidth
implements View.OnClickListener {
    private Context mContext;
    private Handler mHandler;
    private NavIconData mIcon;

    public NavIcon(Context context, NavIconData icon) {
        super(context);
        int padding = (int)TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.mContext = context;
        this.mIcon = icon;
        this.setPadding(padding, 0, padding, 0);
        this.mHandler = new Handler();
        this.setVisibility(8);
        this.setImageDrawable(icon.iconUrl);
        this.setOnClickListener(this);
    }

    private void setImageDrawable(final String url) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                final Drawable image = NavIcon.this.fetchImage(url);
                if (image != null) {
                    NavIcon.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            NavIcon.this.setImageDrawable(image);
                            NavIcon.this.setVisibility(0);
                            NavIcon.this.requestLayout();
                        }
                    });
                }
            }
        });
        t.start();
    }

    private Drawable fetchImage(String urlString) {
        URL url;
        InputStream in = null;
        try {
            url = new URL(urlString);
            in = (InputStream)url.getContent();
            Bitmap b = BitmapFactory.decodeStream((InputStream)in);
            if (b != null) {
                DisplayMetrics m = this.mContext.getResources().getDisplayMetrics();
                int w = b.getWidth();
                int h = b.getHeight();
                int imageWidth = (int)TypedValue.applyDimension((int)1, (float)w, (DisplayMetrics)m);
                int imageHeight = (int)TypedValue.applyDimension((int)1, (float)h, (DisplayMetrics)m);
                if (imageWidth != w || imageHeight != h) {
                    b = Bitmap.createScaledBitmap((Bitmap)b, (int)imageWidth, (int)imageHeight, (boolean)false);
                }
                BitmapDrawable bitmapDrawable = new BitmapDrawable(this.mContext.getResources(), b);
                return bitmapDrawable;
            }
        }
        catch (Exception e) {
            Log.d("NavIcon cannot load resource " + urlString);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                    in = null;
                }
                catch (Exception exception) {}
            }
        }
        try {
            url = new URL(urlString);
            InputStream is = (InputStream)url.getContent();
            Drawable d = Drawable.createFromStream((InputStream)is, (String)"src");
            return d;
        }
        catch (Exception e) {
            Log.e("Cannot fetch image:" + urlString, e);
            return null;
        }
    }

    public void onClick(View v) {
        block14: {
            try {
                if (!(this.mContext instanceof RichMediaActivity)) break block14;
                RichMediaActivity activity = (RichMediaActivity)this.mContext;
                if (this.mIcon.openType == 1) {
                    Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)this.mIcon.clickUrl));
                    activity.startActivity(intent);
                    break block14;
                }
                String url = this.mIcon.clickUrl;
                if (url.startsWith("market:") || url.startsWith("http://market.android.com") || url.startsWith("sms:") || url.startsWith("tel:") || url.startsWith("mailto:") || url.startsWith("voicemail:") || url.startsWith("geo:") || url.startsWith("google.streetview:")) {
                    Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                    activity.startActivity(intent);
                    return;
                }
                if (url.startsWith("mfox:external:")) {
                    url = url.substring(16);
                    Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                    activity.startActivity(intent);
                    return;
                }
                if (url.startsWith("mfox:replayvideo")) {
                    try {
                        Class<?> c = ((Object)((Object)activity)).getClass();
                        Method method = c.getMethod("replayVideo", new Class[0]);
                        method.invoke((Object)activity, new Object[0]);
                    }
                    catch (NoSuchMethodException e) {
                        Log.d("Your activity class has no replayVideo method");
                    }
                    catch (Exception e) {
                        Log.d("Couldn't run replayVideo method in your Activity");
                    }
                    return;
                }
                if (url.startsWith("mfox:playvideo")) {
                    try {
                        Class<?> c = ((Object)((Object)activity)).getClass();
                        Method method = c.getMethod("playVideo", new Class[0]);
                        method.invoke((Object)activity, new Object[0]);
                    }
                    catch (NoSuchMethodException e) {
                        Log.d("Your activity class has no playVideo method");
                    }
                    catch (Exception e) {
                        Log.d("Couldn't run replayVideo method in your Activity");
                    }
                    return;
                }
                if (url.startsWith("mfox:skip")) {
                    activity.finish();
                    return;
                }
                activity.navigate(this.mIcon.clickUrl);
            }
            catch (Exception e) {
                Log.w("Couldn't open URL: " + this.mIcon.clickUrl);
            }
        }
    }
}

