/*
 * Decompiled with CFR 0.152.
 */
package com.adsdk.sdk.video;

import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.adsdk.sdk.video.AspectRatioImageView;
import com.adsdk.sdk.video.AspectRatioImageViewWidth;
import com.adsdk.sdk.video.AutoResizeTextView;
import com.adsdk.sdk.video.InterstitialData;
import com.adsdk.sdk.video.NavIcon;
import com.adsdk.sdk.video.NavIconData;
import com.adsdk.sdk.video.ResourceManager;
import java.lang.ref.WeakReference;
import java.util.Formatter;
import java.util.Locale;

public class InterstitialController
extends LinearLayout {
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final int FADE_OUT = 1;
    private static final int SHOW_PROGRESS = 2;
    private BrowserControl mBrowser;
    private InterstitialData mInterstitialData;
    private Context mContext;
    private ResourceManager mResourceManager;
    private FrameLayout mBrowserView;
    private LinearLayout mTopBar;
    private LinearLayout mBottomBar;
    private AspectRatioImageView mBottomBarBackground;
    private AspectRatioImageView mTopBarBackground;
    private LinearLayout mNavIconsLayout;
    private AspectRatioImageViewWidth mBackButton;
    private AspectRatioImageViewWidth mForwardButton;
    private AspectRatioImageViewWidth mReloadButton;
    private AspectRatioImageViewWidth mExternalButton;
    private TextView mLeftTime;
    private TextView mTitleText;
    StringBuilder mFormatBuilder;
    Formatter mFormatter;
    private boolean mShowing;
    private boolean mFixed;
    private boolean mAutoclose;
    private int mDefaultTimeout;
    private String mTitle;
    private OnReloadListener mOnReloadListener;
    private OnResetAutocloseListener mOnResetAutocloseListener;
    private double buttonWidthPercent = 0.09;
    private Handler mHandler;
    private View.OnClickListener mBackListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (InterstitialController.this.mBrowser != null) {
                InterstitialController.this.mBrowser.goBack();
            }
            InterstitialController.this.show(InterstitialController.this.mDefaultTimeout);
        }
    };
    private View.OnClickListener mReloadListener = new View.OnClickListener(){

        public void onClick(View v) {
            InterstitialController.this.reload();
        }
    };
    private View.OnClickListener mForwardListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (InterstitialController.this.mBrowser != null) {
                InterstitialController.this.mBrowser.goForward();
            }
            InterstitialController.this.show(InterstitialController.this.mDefaultTimeout);
        }
    };
    private View.OnClickListener mExternalListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (InterstitialController.this.mBrowser != null) {
                InterstitialController.this.mBrowser.launchExternalBrowser();
            }
        }
    };

    public InterstitialController(Context context, InterstitialData interstitialData) {
        super(context);
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(metrics);
        this.mContext = context;
        this.mInterstitialData = interstitialData;
        if (this.mInterstitialData == null) {
            throw new IllegalArgumentException("Interstitial info cannot be null");
        }
        this.mFormatBuilder = new StringBuilder();
        this.mFormatter = new Formatter(this.mFormatBuilder, Locale.getDefault());
        this.mFixed = false;
        this.mAutoclose = this.mInterstitialData.autoclose > 0;
        this.mDefaultTimeout = 3000;
        if (this.mInterstitialData != null && !this.mInterstitialData.allowTapNavigationBars) {
            this.mDefaultTimeout = 0;
        }
        this.mHandler = new ResourceHandler(this);
        this.mResourceManager = new ResourceManager(this.mContext, this.mHandler);
        this.buildNavigationBarView(metrics);
    }

    public void setBrowserView(View browserView) {
        this.mBrowserView.addView(browserView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
    }

    public void setBrowser(BrowserControl browser) {
        this.mBrowser = browser;
        this.updateBackForward();
    }

    private void buildNavigationBarView(DisplayMetrics metrics) {
        this.setWeightSum(1.0f);
        this.setOrientation(1);
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.mTopBar = new LinearLayout(this.mContext);
        this.mTopBar.setOrientation(0);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        params.gravity = 48;
        params.weight = 0.0f;
        this.mTopBar.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mTopBar.setBackgroundColor(0);
        this.mTopBar.setGravity(17);
        int padding = (int)TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.mTopBar.setPadding(padding, 0, padding, 0);
        this.mTopBarBackground = new AspectRatioImageView(this.mContext);
        this.mTopBarBackground.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mTopBarBackground.fillParent(true, this.getWidth(), this.mTopBar.getHeight());
        this.addView((View)this.mTopBarBackground, (ViewGroup.LayoutParams)params);
        this.addView((View)this.mTopBar, (ViewGroup.LayoutParams)params);
        this.mTitleText = new TextView(this.mContext);
        params = new LinearLayout.LayoutParams(-2, -2, 1.0f);
        params.gravity = 17;
        this.mTitleText.setTextAppearance(this.mContext, 16973894);
        this.mTitleText.setTypeface(Typeface.defaultFromStyle((int)1));
        this.mTitleText.setGravity(17);
        this.mTopBar.addView((View)this.mTitleText, (ViewGroup.LayoutParams)params);
        this.mBrowserView = new FrameLayout(this.mContext);
        LinearLayout.LayoutParams browserParams = new LinearLayout.LayoutParams(-1, -2);
        browserParams.gravity = 48;
        browserParams.weight = 1.0f;
        this.mBrowserView.setBackgroundColor(-1);
        this.addView((View)this.mBrowserView, (ViewGroup.LayoutParams)browserParams);
        this.mBottomBar = new LinearLayout(this.mContext);
        this.mBottomBar.setOrientation(0);
        params = new LinearLayout.LayoutParams(-1, (int)((double)metrics.widthPixels * 0.119));
        params.gravity = 80;
        params.weight = 0.0f;
        this.mBottomBar.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mBottomBar.setBackgroundColor(0);
        this.mBottomBar.setGravity(16);
        this.mBottomBar.setWeightSum(1.0f);
        this.mBottomBarBackground = new AspectRatioImageView(this.mContext);
        this.mBottomBarBackground.fillParent(true, this.getWidth(), this.mBottomBar.getHeight());
        this.addView((View)this.mBottomBarBackground);
        this.addView((View)this.mBottomBar, (ViewGroup.LayoutParams)params);
        LinearLayout buttonPanel = new LinearLayout(this.mContext);
        params = new LinearLayout.LayoutParams(-2, -1, 0.0f);
        params.gravity = 19;
        buttonPanel.setOrientation(0);
        this.mBottomBar.addView((View)buttonPanel, (ViewGroup.LayoutParams)params);
        padding = (int)TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.mReloadButton = new AspectRatioImageViewWidth(this.mContext);
        params = new LinearLayout.LayoutParams((int)((double)metrics.widthPixels * this.buttonWidthPercent), (int)((double)metrics.widthPixels * this.buttonWidthPercent));
        params.leftMargin = 4;
        params.rightMargin = 4;
        params.gravity = 16;
        this.mReloadButton.setAdjustViewBounds(true);
        this.mReloadButton.setPadding(padding, 0, padding, 0);
        buttonPanel.addView((View)this.mReloadButton, (ViewGroup.LayoutParams)params);
        this.mBackButton = new AspectRatioImageViewWidth(this.mContext);
        this.mBackButton.setPadding(padding, 0, padding, 0);
        buttonPanel.addView((View)this.mBackButton, (ViewGroup.LayoutParams)params);
        this.mForwardButton = new AspectRatioImageViewWidth(this.mContext);
        this.mForwardButton.setPadding(padding, 0, padding, 0);
        buttonPanel.addView((View)this.mForwardButton, (ViewGroup.LayoutParams)params);
        this.mExternalButton = new AspectRatioImageViewWidth(this.mContext);
        this.mExternalButton.setPadding(padding, 0, padding, 0);
        buttonPanel.addView((View)this.mExternalButton, (ViewGroup.LayoutParams)params);
        this.mLeftTime = new AutoResizeTextView(this.mContext);
        params = new LinearLayout.LayoutParams(-2, -2);
        params.gravity = 17;
        this.mLeftTime.setTypeface(Typeface.defaultFromStyle((int)1));
        buttonPanel.addView((View)this.mLeftTime, (ViewGroup.LayoutParams)params);
        this.mNavIconsLayout = new LinearLayout(this.mContext);
        params = new LinearLayout.LayoutParams(-2, -2, 1.0f);
        params.gravity = 21;
        this.mNavIconsLayout.setOrientation(0);
        this.mNavIconsLayout.setPadding(0, 0, 0, 0);
        this.mNavIconsLayout.setGravity(21);
        this.mBottomBar.addView((View)this.mNavIconsLayout, (ViewGroup.LayoutParams)params);
        this.initNavigationBarControllerView(padding, metrics);
    }

    private void initNavigationBarControllerView(int padding, DisplayMetrics metrics) {
        if (!this.mInterstitialData.showBottomNavigationBar) {
            this.mBottomBar.setVisibility(8);
        } else {
            this.mBottomBar.setVisibility(0);
            if (this.mInterstitialData.bottomNavigationBarBackground != null && this.mInterstitialData.bottomNavigationBarBackground.length() > 0) {
                this.mResourceManager.fetchResource(this.mContext, this.mInterstitialData.bottomNavigationBarBackground, -2);
            } else {
                this.mBottomBar.setBackgroundDrawable(this.mResourceManager.getResource(this.mContext, -2));
            }
            if (this.mBackButton != null) {
                if (this.mInterstitialData.backButtonImage != null && this.mInterstitialData.backButtonImage.length() > 0) {
                    this.mBackButton.setBackgroundDrawable(null);
                    this.mResourceManager.fetchResource(this.mContext, this.mInterstitialData.backButtonImage, -14);
                } else {
                    this.mBackButton.setImageDrawable(this.mResourceManager.getResource(this.mContext, -14));
                    this.mBackButton.setEnabled(false);
                }
                this.mBackButton.setOnClickListener(this.mBackListener);
                if (this.mInterstitialData.showBackButton) {
                    this.mBackButton.setVisibility(0);
                } else {
                    this.mBackButton.setVisibility(8);
                }
            }
            if (this.mForwardButton != null) {
                if (this.mInterstitialData.forwardButtonImage != null && this.mInterstitialData.forwardButtonImage.length() > 0) {
                    this.mForwardButton.setBackgroundDrawable(null);
                    this.mResourceManager.fetchResource(this.mContext, this.mInterstitialData.forwardButtonImage, -15);
                } else {
                    this.mForwardButton.setImageDrawable(this.mResourceManager.getResource(this.mContext, -15));
                }
                this.mForwardButton.setOnClickListener(this.mForwardListener);
                if (this.mInterstitialData.showForwardButton) {
                    this.mForwardButton.setVisibility(0);
                } else {
                    this.mForwardButton.setVisibility(8);
                }
            }
            if (this.mReloadButton != null) {
                if (this.mInterstitialData.reloadButtonImage != null && this.mInterstitialData.reloadButtonImage.length() > 0) {
                    this.mReloadButton.setBackgroundDrawable(null);
                    this.mResourceManager.fetchResource(this.mContext, this.mInterstitialData.reloadButtonImage, -16);
                } else {
                    this.mReloadButton.setImageDrawable(this.mResourceManager.getResource(this.mContext, -16));
                }
                this.mReloadButton.setOnClickListener(this.mReloadListener);
                if (this.mInterstitialData.showReloadButton) {
                    this.mReloadButton.setVisibility(0);
                } else {
                    this.mReloadButton.setVisibility(8);
                }
            }
            if (this.mExternalButton != null) {
                if (this.mInterstitialData.externalButtonImage != null && this.mInterstitialData.externalButtonImage.length() > 0) {
                    this.mExternalButton.setBackgroundDrawable(null);
                    this.mResourceManager.fetchResource(this.mContext, this.mInterstitialData.externalButtonImage, -17);
                } else {
                    this.mExternalButton.setImageDrawable(this.mResourceManager.getResource(this.mContext, -17));
                }
                this.mExternalButton.setOnClickListener(this.mExternalListener);
                if (this.mInterstitialData.showExternalButton) {
                    this.mExternalButton.setVisibility(0);
                } else {
                    this.mExternalButton.setVisibility(8);
                }
            }
            this.mFormatBuilder = new StringBuilder();
            this.mFormatter = new Formatter(this.mFormatBuilder, Locale.getDefault());
            if (this.mLeftTime != null) {
                if (this.mInterstitialData.showTimer && this.mAutoclose) {
                    this.mLeftTime.setVisibility(0);
                } else {
                    this.mLeftTime.setVisibility(8);
                }
            }
            if (!this.mInterstitialData.icons.isEmpty()) {
                int i = 0;
                while (i < this.mInterstitialData.icons.size()) {
                    NavIconData iconData = this.mInterstitialData.icons.get(i);
                    NavIcon icon = new NavIcon(this.mContext, iconData);
                    LinearLayout.LayoutParams params = new LinearLayout.LayoutParams((int)((double)metrics.widthPixels * this.buttonWidthPercent), (int)((double)metrics.widthPixels * this.buttonWidthPercent));
                    this.mNavIconsLayout.addView((View)icon, (ViewGroup.LayoutParams)params);
                    ++i;
                }
            }
        }
        if (!this.mInterstitialData.showTopNavigationBar) {
            this.mTopBar.setVisibility(8);
        } else {
            this.mTopBar.setVisibility(0);
            if (this.mInterstitialData.topNavigationBarBackground != null && this.mInterstitialData.topNavigationBarBackground.length() > 0) {
                this.mResourceManager.fetchResource(this.mContext, this.mInterstitialData.topNavigationBarBackground, -1);
            } else {
                this.mTopBarBackground.setImageDrawable(this.mResourceManager.getResource(this.mContext, -1));
            }
            if (this.mTitleText != null) {
                if (this.mInterstitialData.topNavigationBarTitleType == 0) {
                    this.mTitleText.setText((CharSequence)this.mInterstitialData.topNavigationBarTitle);
                } else if (this.mInterstitialData.topNavigationBarTitleType == 2) {
                    this.mTitleText.setVisibility(8);
                }
            }
        }
        if (!this.mInterstitialData.showNavigationBars) {
            if (this.mTopBar != null) {
                this.mTopBar.setVisibility(8);
            }
            if (this.mBottomBar != null) {
                this.mBottomBar.setVisibility(8);
            }
        }
    }

    public void resetAutoclose() {
        if (this.mAutoclose) {
            this.mAutoclose = false;
            if (this.mOnResetAutocloseListener != null) {
                this.mOnResetAutocloseListener.onResetAutoclose();
            }
        }
    }

    public void show() {
        this.show(this.mDefaultTimeout);
    }

    public void show(int timeout) {
        if (timeout == 0) {
            this.mFixed = true;
        }
        if (!this.mShowing) {
            this.setProgress();
            if (this.mTopBar != null && this.mInterstitialData.showTopNavigationBar) {
                this.mTopBar.setVisibility(0);
            }
            if (this.mBottomBar != null && this.mInterstitialData.showBottomNavigationBar) {
                this.mBottomBar.setVisibility(0);
            }
            this.mShowing = true;
        }
        this.updateBackForward();
        this.mHandler.removeMessages(1);
        this.mHandler.sendEmptyMessage(2);
        if (timeout != 0 && !this.mFixed) {
            Message msg = this.mHandler.obtainMessage(1);
            this.mHandler.sendMessageDelayed(msg, (long)timeout);
        }
    }

    public boolean isShowing() {
        return this.mShowing;
    }

    public void hide() {
        if (this.canToggle() && this.mShowing) {
            this.mHandler.removeMessages(2);
            if (this.mTopBar != null) {
                this.mTopBar.setVisibility(8);
            }
            if (this.mBottomBar != null) {
                this.mBottomBar.setVisibility(8);
            }
            this.mShowing = false;
            this.mFixed = false;
        }
    }

    public void resizeTopBar(int bottom) {
        if (bottom <= 0) {
            return;
        }
        int padding = (int)TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        if (this.mTopBar != null) {
            ViewGroup.LayoutParams params = this.mTopBar.getLayoutParams();
            params.height = bottom + padding;
            this.mTopBar.setLayoutParams(params);
        }
    }

    public void toggle() {
        if (this.canToggle()) {
            if (this.mShowing) {
                this.hide();
            } else {
                this.show();
            }
        }
    }

    public void reload() {
        if (this.mBrowser != null) {
            this.mBrowser.reload();
        }
        this.setProgress();
        this.show(this.mDefaultTimeout);
        if (this.mOnReloadListener != null) {
            this.mOnReloadListener.onInterstitialReload();
        }
    }

    public void pageLoaded() {
        this.setProgress();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleMessage(Message msg) {
        block18: {
            switch (msg.what) {
                case 1: {
                    this.hide();
                    return;
                }
                case 100: {
                    switch (msg.arg1) {
                        case -1: {
                            Drawable d;
                            if (this.mTopBar == null || (d = this.mResourceManager.getResource(this.mContext, -1)) == null) return;
                            this.mTopBarBackground.setImageDrawable(d);
                            break block18;
                        }
                        case -2: {
                            Drawable d;
                            if (this.mBottomBar == null || (d = this.mResourceManager.getResource(this.mContext, -2)) == null) return;
                            this.mBottomBar.setBackgroundDrawable(d);
                            break block18;
                        }
                        case -14: {
                            Drawable d;
                            if (this.mBackButton == null || (d = this.mResourceManager.getResource(this.mContext, -14)) == null) return;
                            this.mBackButton.setImageDrawable(d);
                            break block18;
                        }
                        case -15: {
                            Drawable d;
                            if (this.mForwardButton == null || (d = this.mResourceManager.getResource(this.mContext, -15)) == null) return;
                            this.mForwardButton.setImageDrawable(d);
                            break block18;
                        }
                        case -16: {
                            Drawable d;
                            if (this.mReloadButton == null || (d = this.mResourceManager.getResource(this.mContext, -16)) == null) return;
                            this.mReloadButton.setImageDrawable(d);
                            break block18;
                        }
                        case -17: {
                            Drawable d;
                            if (this.mExternalButton == null || (d = this.mResourceManager.getResource(this.mContext, -17)) == null) return;
                            this.mExternalButton.setImageDrawable(d);
                        }
                    }
                }
            }
        }
    }

    private String stringForTime(int timeMs) {
        int totalSeconds = timeMs / 1000;
        int seconds = totalSeconds % 60;
        int minutes = totalSeconds / 60 % 60;
        int hours = totalSeconds / 3600;
        this.mFormatBuilder.setLength(0);
        if (hours > 0) {
            return this.mFormatter.format("%d:%02d:%02d", hours, minutes, seconds).toString();
        }
        if (minutes > 0) {
            return this.mFormatter.format("%02d:%02d", minutes, seconds).toString();
        }
        return this.mFormatter.format("0:%02d", seconds).toString();
    }

    private int setProgress() {
        int position = 0;
        if (this.mBrowser != null) {
            position = this.mBrowser.getTime();
        }
        int duration = this.mInterstitialData.autoclose * 1000;
        int timeLeft = duration - position;
        if (this.mAutoclose && duration > 0 && timeLeft >= 0) {
            if (this.mLeftTime != null) {
                this.mLeftTime.setText((CharSequence)this.stringForTime(timeLeft));
            }
        } else if (this.mLeftTime != null) {
            this.mLeftTime.setVisibility(8);
        }
        if (!(this.mTitleText == null || this.mInterstitialData.topNavigationBarTitleType != 1 || this.mBrowser == null || this.mTitle != null && this.mTitle.equals(this.mBrowser.getPageTitle()))) {
            this.mTitle = this.mBrowser.getPageTitle();
            this.mTitleText.setText((CharSequence)this.mTitle);
        }
        this.updateBackForward();
        return position;
    }

    private void updateBackForward() {
        if (this.mBrowser == null) {
            return;
        }
        if (this.mBrowser.canGoBack()) {
            if (this.mBackButton != null) {
                this.mBackButton.setEnabled(true);
            }
        } else if (this.mBackButton != null) {
            this.mBackButton.setEnabled(false);
        }
        if (this.mBrowser.canGoForward()) {
            if (this.mForwardButton != null) {
                this.mForwardButton.setEnabled(true);
            }
        } else if (this.mForwardButton != null) {
            this.mForwardButton.setEnabled(false);
        }
    }

    public boolean canToggle() {
        return this.mInterstitialData.allowTapNavigationBars;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        this.onTouchEvent(ev);
        return false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        super.onTouchEvent(event);
        this.resetAutoclose();
        return true;
    }

    public void setOnReloadListener(OnReloadListener l) {
        this.mOnReloadListener = l;
    }

    public void setOnResetAutocloseListener(OnResetAutocloseListener l) {
        this.mOnResetAutocloseListener = l;
    }

    public static interface BrowserControl {
        public int getTime();

        public boolean canGoBack();

        public boolean canGoForward();

        public void goBack();

        public void goForward();

        public void reload();

        public void launchExternalBrowser();

        public String getPageTitle();
    }

    public static interface OnReloadListener {
        public void onInterstitialReload();
    }

    public static interface OnResetAutocloseListener {
        public void onResetAutoclose();
    }

    private static class ResourceHandler
    extends Handler {
        WeakReference<InterstitialController> interstitialController;

        public ResourceHandler(InterstitialController i) {
            this.interstitialController = new WeakReference<InterstitialController>(i);
        }

        public void handleMessage(Message msg) {
            InterstitialController wInterstitialController = (InterstitialController)((Object)this.interstitialController.get());
            if (wInterstitialController != null) {
                switch (msg.what) {
                    case 2: {
                        wInterstitialController.setProgress();
                        if (!wInterstitialController.mShowing || !((InterstitialController)wInterstitialController).mInterstitialData.showTimer) break;
                        msg = this.obtainMessage(2);
                        this.sendMessageDelayed(msg, 1000L);
                        break;
                    }
                    default: {
                        wInterstitialController.handleMessage(msg);
                    }
                }
            }
        }
    }
}

