/*
 * Decompiled with CFR 0.152.
 */
package com.adsdk.sdk.mraid;

import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.adsdk.sdk.mraid.BaseAdapter;
import com.adsdk.sdk.mraid.MoPubView;
import com.adsdk.sdk.mraid.MraidView;

public class MraidAdapter
extends BaseAdapter {
    private MraidView mMraidView;
    private boolean mPreviousAutorefreshSetting;

    @Override
    public void init(MoPubView view, String jsonParams) {
        super.init(view, jsonParams);
        this.mPreviousAutorefreshSetting = false;
    }

    @Override
    public void loadAd() {
        if (this.isInvalidated()) {
            return;
        }
        this.mMraidView = new MraidView(this.mMoPubView.getContext());
        this.mMraidView.loadHtmlData(this.mJsonParams);
        this.initMraidListeners();
        this.mMoPubView.removeAllViews();
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        layoutParams.gravity = 17;
        this.mMoPubView.addView((View)this.mMraidView, (ViewGroup.LayoutParams)layoutParams);
    }

    @Override
    public void invalidate() {
        this.mMoPubView = null;
        if (this.mMraidView != null) {
            this.mMraidView.destroy();
        }
        super.invalidate();
    }

    private void initMraidListeners() {
        this.mMraidView.setOnReadyListener(new MraidView.OnReadyListener(){

            @Override
            public void onReady(MraidView view) {
                if (!MraidAdapter.this.isInvalidated()) {
                    MraidAdapter.this.mMoPubView.nativeAdLoaded();
                }
            }
        });
        this.mMraidView.setOnExpandListener(new MraidView.OnExpandListener(){

            @Override
            public void onExpand(MraidView view) {
                if (!MraidAdapter.this.isInvalidated()) {
                    MraidAdapter.this.mPreviousAutorefreshSetting = MraidAdapter.this.mMoPubView.getAutorefreshEnabled();
                    MraidAdapter.this.mMoPubView.setAutorefreshEnabled(false);
                    MraidAdapter.this.mMoPubView.adPresentedOverlay();
                    MraidAdapter.this.mMoPubView.registerClick();
                }
            }
        });
        this.mMraidView.setOnCloseListener(new MraidView.OnCloseListener(){

            @Override
            public void onClose(MraidView view, MraidView.ViewState newViewState) {
                if (!MraidAdapter.this.isInvalidated()) {
                    MraidAdapter.this.mMoPubView.setAutorefreshEnabled(MraidAdapter.this.mPreviousAutorefreshSetting);
                    MraidAdapter.this.mMoPubView.adClosed();
                }
            }
        });
        this.mMraidView.setOnFailureListener(new MraidView.OnFailureListener(){

            @Override
            public void onFailure(MraidView view) {
                if (!MraidAdapter.this.isInvalidated()) {
                    MraidAdapter.this.mMoPubView.loadFailUrl();
                }
            }
        });
    }
}

