/*
 * Decompiled with CFR 0.152.
 */
package com.adsdk.sdk.banner;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;
import com.adsdk.sdk.Log;

public class InAppWebView
extends Activity {
    public static final String URL_EXTRA = "extra_url";

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().requestFeature(2);
        this.getWindow().setFeatureInt(2, -1);
        Intent intent = this.getIntent();
        this.initializeWebView(intent);
    }

    private void initializeWebView(Intent intent) {
        WebView webView = new WebView((Context)this);
        this.setContentView((View)webView);
        WebSettings webSettings = webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSupportZoom(true);
        webSettings.setBuiltInZoomControls(true);
        webSettings.setUseWideViewPort(true);
        webView.setWebViewClient(new WebViewClient(){

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                Activity a = (Activity)view.getContext();
                Toast.makeText((Context)a, (CharSequence)("MRAID error: " + description), (int)0).show();
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (url == null) {
                    return false;
                }
                Uri uri = Uri.parse((String)url);
                String host = uri.getHost();
                if ((url.startsWith("http:") || url.startsWith("https:")) && !"play.google.com".equals(host) && !"market.android.com".equals(host)) {
                    view.loadUrl(url);
                    return true;
                }
                try {
                    InAppWebView.this.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)url)));
                }
                catch (ActivityNotFoundException exception) {
                    Log.w("MoPub", "Unable to start activity for " + url + ". " + "Ensure that your phone can handle this intent.");
                }
                InAppWebView.this.finish();
                return true;
            }
        });
        webView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int progress) {
                Activity a = (Activity)view.getContext();
                a.setTitle((CharSequence)"Loading...");
                a.setProgress(progress * 100);
                if (progress == 100) {
                    a.setTitle((CharSequence)view.getUrl());
                }
            }
        });
        webView.loadUrl(intent.getStringExtra("REDIRECT_URI"));
    }
}

