/*
 * Decompiled with CFR 0.152.
 */
package com.adsdk.sdk.banner;

import android.content.Context;
import android.content.Intent;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.ViewFlipper;
import com.adsdk.sdk.AdListener;
import com.adsdk.sdk.BannerAd;
import com.adsdk.sdk.Log;
import com.adsdk.sdk.banner.InAppWebView;
import com.adsdk.sdk.data.ClickType;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;

public class BannerAdView
extends RelativeLayout {
    public static final int LIVE = 0;
    public static final int TEST = 1;
    private boolean animation;
    private boolean isInternalBrowser = false;
    private BannerAd response;
    private Animation fadeInAnimation = null;
    private Animation fadeOutAnimation = null;
    private WebSettings webSettings;
    private Context mContext = null;
    protected boolean mIsInForeground;
    private WebView firstWebView;
    private WebView secondWebView;
    private ViewFlipper viewFlipper;
    private AdListener adListener;
    private boolean touchMove;
    private InputStream xml;
    private static Method mWebView_SetLayerType;
    private static Field mWebView_LAYER_TYPE_SOFTWARE;
    private final Handler updateHandler = new Handler();

    static {
        BannerAdView.initCompatibility();
    }

    public void setWidth(int width) {
    }

    public void setHeight(int width) {
    }

    public BannerAdView(Context context, BannerAd response, AdListener adListener) {
        this(context, response, false, adListener);
    }

    public BannerAdView(Context context, InputStream xml, boolean animation) {
        super(context);
        this.xml = xml;
        this.mContext = context;
        this.animation = animation;
        this.initialize(context);
    }

    public BannerAdView(Context context, BannerAd response, boolean animation, AdListener adListener) {
        super(context);
        this.response = response;
        this.mContext = context;
        this.animation = animation;
        this.adListener = adListener;
        this.initialize(context);
    }

    private WebView createWebView(Context context) {
        WebView webView = new WebView(this.getContext()){

            public void draw(Canvas canvas) {
                if (this.getWidth() > 0 && this.getHeight() > 0) {
                    super.draw(canvas);
                }
            }
        };
        this.webSettings = webView.getSettings();
        this.webSettings.setJavaScriptEnabled(true);
        webView.setBackgroundColor(0);
        BannerAdView.setLayer(webView);
        webView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (BannerAdView.this.response.getSkipOverlay() == 1) {
                    BannerAdView.this.doOpenUrl(url);
                    Log.i("TouchListener", "false");
                    return true;
                }
                Log.i("TouchListener", "default");
                BannerAdView.this.openLink();
                return true;
            }
        });
        webView.setVerticalScrollBarEnabled(false);
        webView.setHorizontalScrollBarEnabled(false);
        return webView;
    }

    private void doOpenUrl(String url) {
        this.notifyAdClicked();
        if (this.response.getClickType() != null && this.response.getClickType().equals((Object)ClickType.INAPP) && (url.startsWith("http://") || url.startsWith("https://"))) {
            if (url.endsWith(".mp4")) {
                Intent i = new Intent("android.intent.action.VIEW");
                i.setDataAndType(Uri.parse((String)url), "video/mp4");
                this.getContext().startActivity(i);
            } else {
                Intent intent = new Intent(this.getContext(), InAppWebView.class);
                intent.putExtra("REDIRECT_URI", url);
                this.getContext().startActivity(intent);
            }
        } else {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            this.getContext().startActivity(intent);
        }
    }

    private static void initCompatibility() {
        try {
            Method[] methodArray = WebView.class.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (m.getName().equals("setLayerType")) {
                    mWebView_SetLayerType = m;
                    break;
                }
                ++n2;
            }
            Log.v("set layer " + mWebView_SetLayerType);
            mWebView_LAYER_TYPE_SOFTWARE = WebView.class.getField("LAYER_TYPE_SOFTWARE");
            Log.v("set1 layer " + mWebView_LAYER_TYPE_SOFTWARE);
        }
        catch (SecurityException e) {
            Log.v("SecurityException");
        }
        catch (NoSuchFieldException e) {
            Log.v("NoSuchFieldException");
        }
    }

    private static void setLayer(WebView webView) {
        if (mWebView_SetLayerType != null && mWebView_LAYER_TYPE_SOFTWARE != null) {
            try {
                Log.v("Set Layer is supported");
                mWebView_SetLayerType.invoke((Object)webView, mWebView_LAYER_TYPE_SOFTWARE.getInt(WebView.class), null);
            }
            catch (InvocationTargetException ite) {
                Log.v("Set InvocationTargetException");
            }
            catch (IllegalArgumentException e) {
                Log.v("Set IllegalArgumentException");
            }
            catch (IllegalAccessException e) {
                Log.v("Set IllegalAccessException");
            }
        } else {
            Log.v("Set Layer is not supported");
        }
    }

    private void buildBannerView() {
        this.firstWebView = this.createWebView(this.mContext);
        this.secondWebView = this.createWebView(this.mContext);
        Log.d("ADSDK", "Create view flipper");
        this.viewFlipper = new ViewFlipper(this.getContext()){

            protected void onDetachedFromWindow() {
                try {
                    super.onDetachedFromWindow();
                }
                catch (IllegalArgumentException e) {
                    this.stopFlipping();
                }
            }
        };
        float scale = this.mContext.getResources().getDisplayMetrics().density;
        this.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams((int)(300.0f * scale + 0.5f), (int)(50.0f * scale + 0.5f)));
        FrameLayout.LayoutParams webViewParams = new FrameLayout.LayoutParams(-1, -1);
        this.viewFlipper.addView((View)this.firstWebView, (ViewGroup.LayoutParams)webViewParams);
        this.viewFlipper.addView((View)this.secondWebView, (ViewGroup.LayoutParams)webViewParams);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        this.addView((View)this.viewFlipper, (ViewGroup.LayoutParams)params);
        Log.d("ADSDK", "animation: " + this.animation);
        if (this.animation) {
            this.fadeInAnimation = new TranslateAnimation(2, 0.0f, 2, 0.0f, 2, 1.0f, 2, 0.0f);
            this.fadeInAnimation.setDuration(1000L);
            this.fadeOutAnimation = new TranslateAnimation(2, 0.0f, 2, 0.0f, 2, 0.0f, 2, -1.0f);
            this.fadeOutAnimation.setDuration(1000L);
            this.viewFlipper.setInAnimation(this.fadeInAnimation);
            this.viewFlipper.setOutAnimation(this.fadeOutAnimation);
        }
    }

    private void initialize(Context context) {
        BannerAdView.initCompatibility();
        this.buildBannerView();
        this.showContent();
    }

    public boolean isInternalBrowser() {
        return this.isInternalBrowser;
    }

    private void notifyAdClicked() {
        this.updateHandler.post(new Runnable(){

            @Override
            public void run() {
                if (BannerAdView.this.adListener != null) {
                    Log.d("ADSDK", "notify bannerListener of ad clicked: " + BannerAdView.this.adListener.getClass().getName());
                    BannerAdView.this.adListener.adClicked();
                }
            }
        });
    }

    private void notifyLoadAdSucceeded() {
        this.updateHandler.post(new Runnable(){

            @Override
            public void run() {
                if (BannerAdView.this.adListener != null) {
                    Log.d("ADSDK", "notify bannerListener of load succeeded: " + BannerAdView.this.adListener.getClass().getName());
                    BannerAdView.this.adListener.adLoadSucceeded(null);
                }
            }
        });
    }

    private void openLink() {
        if (this.response != null && this.response.getClickUrl() != null) {
            this.doOpenUrl(this.response.getClickUrl());
        }
    }

    public void setAdListener(AdListener bannerListener) {
        this.adListener = bannerListener;
    }

    public void setInternalBrowser(boolean isInternalBrowser) {
        this.isInternalBrowser = isInternalBrowser;
    }

    private void showContent() {
        try {
            WebView webView = this.viewFlipper.getCurrentView() == this.firstWebView ? this.secondWebView : this.firstWebView;
            if (this.response.getType() == 0) {
                String text = MessageFormat.format("<body style='\"'margin: 0px; padding: 0px; text-align:center;'\"'><img src='\"'{0}'\"' width='\"'{1}'dp\"' height='\"'{2}'dp\"'/></body>", this.response.getImageUrl(), this.response.getBannerWidth(), this.response.getBannerHeight());
                Log.d("ADSDK", "set image: " + text);
                text = Uri.encode((String)("<style>* { -webkit-tap-highlight-color: rgba(0,0,0,0);} img {width:100%;height:100%}</style>" + text));
                webView.loadData(text, "text/html", "UTF-8");
                this.notifyLoadAdSucceeded();
            } else if (this.response.getType() == 1) {
                String text = Uri.encode((String)("<style>* { -webkit-tap-highlight-color: rgba(0,0,0,0);} img {width:100%;height:100%}</style>" + this.response.getText()));
                Log.d("ADSDK", "set text: " + text);
                webView.loadData(text, "text/html", "UTF-8");
                this.notifyLoadAdSucceeded();
            }
            if (this.viewFlipper.getCurrentView() == this.firstWebView) {
                Log.d("ADSDK", "show next");
                this.viewFlipper.showNext();
            } else {
                Log.d("ADSDK", "show previous");
                this.viewFlipper.showPrevious();
            }
        }
        catch (Throwable t) {
            Log.e("ADSDK", "Exception in show content", t);
        }
    }
}

