/*
 * Decompiled with CFR 0.152.
 */
package com.adsdk.sdk;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Build;
import android.os.Handler;
import com.adsdk.sdk.AdListener;
import com.adsdk.sdk.AdRequest;
import com.adsdk.sdk.Log;
import com.adsdk.sdk.RequestRichMediaAd;
import com.adsdk.sdk.Util;
import com.adsdk.sdk.video.ResourceManager;
import com.adsdk.sdk.video.RichMediaActivity;
import com.adsdk.sdk.video.RichMediaAd;
import com.adsdk.sdk.video.TrackerService;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;

public class AdManager {
    private static HashMap<Long, AdManager> sRunningAds = new HashMap();
    private String mPublisherId;
    private String mUniqueId1;
    private String mUniqueId2;
    private boolean mIncludeLocation;
    private static Context mContext;
    private Thread mRequestThread;
    private Handler mHandler;
    private AdRequest mRequest = null;
    private AdListener mListener;
    private boolean mEnabled = true;
    private RichMediaAd mResponse;
    private String requestURL;
    private String mUserAgent;

    public static AdManager getAdManager(RichMediaAd ad) {
        AdManager adManager = sRunningAds.remove(ad.getTimestamp());
        if (adManager == null) {
            Log.d("Cannot find AdManager with running ad:" + ad.getTimestamp());
        }
        return adManager;
    }

    public static void closeRunningAd(RichMediaAd ad, boolean result) {
        AdManager adManager = sRunningAds.remove(ad.getTimestamp());
        if (adManager == null) {
            Log.d("Cannot find AdManager with running ad:" + ad.getTimestamp());
            return;
        }
        Log.d("Notify closing event to AdManager with running ad:" + ad.getTimestamp());
        adManager.notifyAdClose(ad, result);
    }

    public void release() {
        TrackerService.release();
        ResourceManager.cancel();
    }

    public AdManager(Context ctx, String requestURL, String publisherId, boolean includeLocation) throws IllegalArgumentException {
        AdManager.setmContext(ctx);
        this.requestURL = requestURL;
        this.mPublisherId = publisherId;
        this.mIncludeLocation = includeLocation;
        this.mRequestThread = null;
        this.mHandler = new Handler();
        this.initialize();
    }

    public void setListener(AdListener listener) {
        this.mListener = listener;
    }

    public void requestAd() {
        if (!this.mEnabled) {
            Log.w("Cannot request rich adds on low memory devices");
            return;
        }
        if (this.mRequestThread == null) {
            Log.d("Requesting Ad (v4.1.6-1.0)");
            this.mResponse = null;
            this.mRequestThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    block14: {
                        while (ResourceManager.isDownloading()) {
                            try {
                                Thread.sleep(200L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        Log.d("starting request thread");
                        try {
                            RequestRichMediaAd requestAd = new RequestRichMediaAd();
                            AdRequest request = AdManager.this.getRequest();
                            AdManager.this.mResponse = (RichMediaAd)requestAd.sendRequest(request);
                            if (AdManager.this.mResponse.getVideo() != null && Build.VERSION.SDK_INT < 8) {
                                Log.d("Not capable of video");
                                AdManager.this.notifyNoAdFound();
                            } else if (AdManager.this.mResponse.getType() == 3 || AdManager.this.mResponse.getType() == 4 || AdManager.this.mResponse.getType() == 5 || AdManager.this.mResponse.getType() == 6) {
                                Log.d("response OK received");
                                if (AdManager.this.mListener != null) {
                                    AdManager.this.mHandler.post(new Runnable(){

                                        @Override
                                        public void run() {
                                            AdManager.this.mListener.adLoadSucceeded(AdManager.this.mResponse);
                                        }
                                    });
                                }
                            } else if (AdManager.this.mResponse.getType() == 2) {
                                Log.d("response NO AD received");
                                if (AdManager.this.mListener != null) {
                                    AdManager.this.mHandler.post(new Runnable(){

                                        @Override
                                        public void run() {
                                            AdManager.this.notifyNoAdFound();
                                        }
                                    });
                                }
                            } else {
                                Log.w("response BANNER received");
                                if (AdManager.this.mListener != null) {
                                    AdManager.this.mHandler.post(new Runnable(){

                                        @Override
                                        public void run() {
                                            AdManager.this.notifyNoAdFound();
                                        }
                                    });
                                }
                            }
                        }
                        catch (Throwable t) {
                            AdManager.this.mResponse = new RichMediaAd();
                            AdManager.this.mResponse.setType(-1);
                            if (AdManager.this.mListener == null) break block14;
                            Log.d("Ad Load failed. Reason:" + t);
                            t.printStackTrace();
                            AdManager.this.mHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    AdManager.this.notifyNoAdFound();
                                }
                            });
                        }
                    }
                    Log.d("finishing ad request thread");
                    AdManager.this.mRequestThread = null;
                }
            });
            this.mRequestThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable ex) {
                    AdManager.this.mResponse = new RichMediaAd();
                    AdManager.this.mResponse.setType(-1);
                    Log.e("Handling exception in ad request thread", ex);
                    AdManager.this.mRequestThread = null;
                }
            });
            this.mRequestThread.start();
        } else {
            Log.w("Request thread already running");
        }
    }

    public void setRequestURL(String requestURL) {
        this.requestURL = requestURL;
    }

    public void requestAd(final InputStream xml) {
        if (!this.mEnabled) {
            Log.w("Cannot request rich adds on low memory devices");
            return;
        }
        if (this.mRequestThread == null) {
            Log.d("Requesting Ad (v4.1.6-1.0)");
            this.mResponse = null;
            this.mRequestThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    block9: {
                        while (ResourceManager.isDownloading()) {
                            try {
                                Thread.sleep(200L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        Log.d("starting request thread");
                        try {
                            RequestRichMediaAd requestAd = new RequestRichMediaAd(xml);
                            AdRequest request = AdManager.this.getRequest();
                            AdManager.this.mResponse = (RichMediaAd)requestAd.sendRequest(request);
                            if (AdManager.this.mResponse.getType() != 2) {
                                Log.d("response OK received");
                                if (AdManager.this.mListener != null) {
                                    AdManager.this.mHandler.post(new Runnable(){

                                        @Override
                                        public void run() {
                                            AdManager.this.mListener.adLoadSucceeded(AdManager.this.mResponse);
                                        }
                                    });
                                }
                            } else {
                                Log.d("response NO AD received");
                                if (AdManager.this.mListener != null) {
                                    AdManager.this.mHandler.post(new Runnable(){

                                        @Override
                                        public void run() {
                                            AdManager.this.notifyNoAdFound();
                                        }
                                    });
                                }
                            }
                        }
                        catch (Throwable t) {
                            AdManager.this.mResponse = new RichMediaAd();
                            AdManager.this.mResponse.setType(-1);
                            if (AdManager.this.mListener == null) break block9;
                            Log.d("Ad Load failed. Reason:" + t);
                            t.printStackTrace();
                            AdManager.this.mHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    AdManager.this.notifyNoAdFound();
                                }
                            });
                        }
                    }
                    Log.d("finishing ad request thread");
                    AdManager.this.mRequestThread = null;
                }
            });
            this.mRequestThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable ex) {
                    AdManager.this.mResponse = new RichMediaAd();
                    AdManager.this.mResponse.setType(-1);
                    Log.e("Handling exception in ad request thread", ex);
                    AdManager.this.mRequestThread = null;
                }
            });
            this.mRequestThread.start();
        } else {
            Log.w("Request thread already running");
        }
    }

    public boolean isAdLoaded() {
        return this.mResponse != null;
    }

    public void requestAdAndShow(long timeout) {
        AdListener l = this.mListener;
        this.mListener = null;
        this.requestAd();
        long now = System.currentTimeMillis();
        long timeoutTime = now + timeout;
        while (!this.isAdLoaded() && now < timeoutTime) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            now = System.currentTimeMillis();
        }
        this.mListener = l;
        this.showAd();
    }

    public void showAd() {
        block7: {
            Activity activity = (Activity)this.getContext();
            if (this.mResponse == null || this.mResponse.getType() == 2 || this.mResponse.getType() == -1) {
                this.notifyAdShown(this.mResponse, false);
                return;
            }
            RichMediaAd ad = this.mResponse;
            boolean result = false;
            try {
                try {
                    if (Util.isNetworkAvailable(this.getContext())) {
                        ad.setTimestamp(System.currentTimeMillis());
                        Log.v("Showing Ad:" + ad);
                        Intent intent = new Intent((Context)activity, RichMediaActivity.class);
                        intent.putExtra("RICH_AD_DATA", (Serializable)ad);
                        activity.startActivityForResult(intent, 0);
                        int enterAnim = Util.getEnterAnimation(ad.getAnimation());
                        int exitAnim = Util.getExitAnimation(ad.getAnimation());
                        RichMediaActivity.setActivityAnimation(activity, enterAnim, exitAnim);
                        result = true;
                        sRunningAds.put(ad.getTimestamp(), this);
                        break block7;
                    }
                    Log.d("No network available. Cannot show Ad.");
                }
                catch (Exception e) {
                    Log.e("Unknown exception when showing Ad", e);
                    this.notifyAdShown(ad, result);
                }
            }
            finally {
                this.notifyAdShown(ad, result);
            }
        }
    }

    private void initialize() throws IllegalArgumentException {
        this.mUserAgent = Util.getDefaultUserAgentString(this.getContext());
        Log.LOGGING_ENABLED = Log.isLoggingEnabled(AdManager.getmContext());
        Log.d("Ad SDK Version:4.1.6");
        this.mUniqueId1 = Util.getTelephonyDeviceId(this.getContext());
        this.mUniqueId2 = Util.getDeviceId(this.getContext());
        if (this.mPublisherId == null || this.mPublisherId.length() == 0) {
            Log.e("Publisher Id cannot be null or empty");
            throw new IllegalArgumentException("User Id cannot be null or empty");
        }
        if (this.mUniqueId2 == null || this.mUniqueId2.length() == 0) {
            Log.e("Cannot get system device Id");
            throw new IllegalArgumentException("System Device Id cannot be null or empty");
        }
        Log.d("AdManager Publisher Id:" + this.mPublisherId + " Device Id:" + this.mUniqueId1 + " DeviceId2:" + this.mUniqueId2);
        this.mEnabled = Util.getMemoryClass(this.getContext()) > 16;
        Util.initializeAnimations(this.getContext());
    }

    private void notifyNoAdFound() {
        if (this.mListener != null) {
            Log.d("No ad found.");
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    AdManager.this.mListener.noAdFound();
                }
            });
        }
        this.mResponse = null;
    }

    private void notifyAdShown(final RichMediaAd ad, final boolean ok) {
        if (this.mListener != null) {
            Log.d("Ad Shown. Result:" + ok);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    AdManager.this.mListener.adShown(ad, ok);
                }
            });
        }
        this.mResponse = null;
    }

    private void notifyAdClose(final RichMediaAd ad, final boolean ok) {
        if (this.mListener != null) {
            Log.d("Ad Close. Result:" + ok);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    AdManager.this.mListener.adClosed(ad, ok);
                }
            });
        }
    }

    private AdRequest getRequest() {
        if (this.mRequest == null) {
            this.mRequest = new AdRequest();
            this.mRequest.setDeviceId(this.mUniqueId1);
            this.mRequest.setDeviceId2(this.mUniqueId2);
            this.mRequest.setPublisherId(this.mPublisherId);
            this.mRequest.setUserAgent(this.mUserAgent);
            this.mRequest.setUserAgent2(Util.buildUserAgent());
        }
        Location location = null;
        if (this.mIncludeLocation) {
            location = Util.getLocation(this.getContext());
        }
        if (location != null) {
            Log.d("location is longitude: " + location.getLongitude() + ", latitude: " + location.getLatitude());
            this.mRequest.setLatitude(location.getLatitude());
            this.mRequest.setLongitude(location.getLongitude());
        } else {
            this.mRequest.setLatitude(0.0);
            this.mRequest.setLongitude(0.0);
        }
        this.mRequest.setConnectionType(Util.getConnectionType(this.getContext()));
        this.mRequest.setIpAddress(Util.getLocalIpAddress());
        this.mRequest.setTimestamp(System.currentTimeMillis());
        this.mRequest.setType(1);
        this.mRequest.setRequestURL(this.requestURL);
        Log.d("Getting new request:" + this.mRequest.toString());
        return this.mRequest;
    }

    private Context getContext() {
        return AdManager.getmContext();
    }

    private static Context getmContext() {
        return mContext;
    }

    private static void setmContext(Context mContext) {
        AdManager.mContext = mContext;
    }
}

