/*
 * Decompiled with CFR 0.152.
 */
package com.adsdk.sdk.video;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.adsdk.sdk.Log;
import com.adsdk.sdk.video.InterstitialController;
import com.adsdk.sdk.video.ResourceManager;
import com.adsdk.sdk.video.WebViewClient;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class WebFrame
extends FrameLayout
implements InterstitialController.BrowserControl {
    private WebView mWebView;
    private WebViewClient mWebViewClient;
    private Activity mActivity;
    private InterstitialController mController;
    private ImageView mExitButton;
    private boolean enableZoom = true;
    private static Method mWebView_SetLayerType;
    private static Field mWebView_LAYER_TYPE_SOFTWARE;

    static {
        WebFrame.initCompatibility();
    }

    private static void initCompatibility() {
        try {
            Method[] methodArray = WebView.class.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (m.getName().equals("setLayerType")) {
                    mWebView_SetLayerType = m;
                    break;
                }
                ++n2;
            }
            Log.v("set layer " + mWebView_SetLayerType);
            mWebView_LAYER_TYPE_SOFTWARE = WebView.class.getField("LAYER_TYPE_SOFTWARE");
            Log.v("set1 layer " + mWebView_LAYER_TYPE_SOFTWARE);
        }
        catch (SecurityException e) {
            Log.v("SecurityException");
        }
        catch (NoSuchFieldException e) {
            Log.v("NoSuchFieldException");
        }
    }

    private static void setLayer(WebView webView) {
        if (mWebView_SetLayerType != null && mWebView_LAYER_TYPE_SOFTWARE != null) {
            try {
                Log.v("Set Layer is supported");
                mWebView_SetLayerType.invoke((Object)webView, mWebView_LAYER_TYPE_SOFTWARE.getInt(WebView.class), null);
            }
            catch (InvocationTargetException ite) {
                Log.v("Set InvocationTargetException");
            }
            catch (IllegalArgumentException e) {
                Log.v("Set IllegalArgumentException");
            }
            catch (IllegalAccessException e) {
                Log.v("Set IllegalAccessException");
            }
        } else {
            Log.v("Set Layer is not supported");
        }
    }

    public WebFrame(Activity context, boolean allowNavigation, boolean scroll, boolean showExit) {
        super((Context)context);
        WebFrame.initCompatibility();
        this.mActivity = context;
        this.mWebView = new WebView((Context)context);
        this.mWebView.setVerticalScrollBarEnabled(scroll);
        this.mWebView.setHorizontalScrollBarEnabled(scroll);
        this.mWebView.setBackgroundColor(0);
        WebFrame.setLayer(this.mWebView);
        WebSettings webSettings = this.mWebView.getSettings();
        webSettings.setSavePassword(false);
        webSettings.setSaveFormData(false);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setPluginsEnabled(true);
        webSettings.setSupportZoom(this.enableZoom);
        webSettings.setBuiltInZoomControls(this.enableZoom);
        this.mWebViewClient = new WebViewClient(this.mActivity, allowNavigation);
        this.mWebView.setWebViewClient((android.webkit.WebViewClient)this.mWebViewClient);
        final Activity localContext = context;
        if (showExit) {
            int margin;
            ImageView bg = new ImageView((Context)context);
            bg.setBackgroundColor(0);
            this.addView((View)bg, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
            this.addView((View)this.mWebView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
            this.mExitButton = new ImageView((Context)context);
            this.mExitButton.setAdjustViewBounds(false);
            this.mExitButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    localContext.finish();
                }
            });
            int buttonSize = (int)TypedValue.applyDimension((int)1, (float)35.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            this.mExitButton.setImageDrawable(ResourceManager.getStaticResource((Context)context, -18));
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(buttonSize, buttonSize, 53);
            params.topMargin = margin = (int)TypedValue.applyDimension((int)1, (float)6.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            params.rightMargin = margin;
            this.addView((View)this.mExitButton, (ViewGroup.LayoutParams)params);
        } else {
            this.addView((View)this.mWebView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
        }
    }

    public void loadUrl(String url) {
        new LoadUrlTask().execute(new String[]{url});
    }

    public void setMarkup(String htmlMarkup) {
        String data = Uri.encode((String)htmlMarkup);
        this.mWebViewClient.setAllowedUrl(null);
        this.mWebView.loadData(data, "text/html", "UTF-8");
    }

    public void setBackgroundColor(int color) {
        super.setBackgroundColor(color);
        this.mWebView.setBackgroundColor(color);
    }

    private String getUserAgentString() {
        return this.mWebView.getSettings().getUserAgentString();
    }

    public WebView getWebView() {
        return this.mWebView;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        this.onTouchEvent(ev);
        return false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        super.onTouchEvent(event);
        return true;
    }

    @Override
    public boolean canGoBack() {
        return this.mWebView.canGoBack();
    }

    @Override
    public void goBack() {
        this.mWebView.goBack();
    }

    @Override
    public boolean canGoForward() {
        return this.mWebView.canGoForward();
    }

    @Override
    public void goForward() {
        this.mWebView.goForward();
    }

    @Override
    public void reload() {
        this.mWebView.reload();
    }

    public void setBrowserController(InterstitialController controller) {
        if (this.mController != null) {
            this.mController.hide();
        }
        this.mController = controller;
        this.attachController();
    }

    private void attachController() {
        if (this.mController != null) {
            this.mController.setBrowser(this);
        }
    }

    @Override
    public int getTime() {
        int time = 0;
        long finishedLoadedTime = this.mWebViewClient.getFinishedLoadingTime();
        if (finishedLoadedTime > 0L) {
            return (int)(System.currentTimeMillis() - finishedLoadedTime);
        }
        return time;
    }

    @Override
    public void launchExternalBrowser() {
        String url = this.mWebViewClient.getAllowedUrl();
        if (url == null || url.length() == 0) {
            url = "about:blank";
        }
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        this.mActivity.startActivity(intent);
    }

    @Override
    public String getPageTitle() {
        return this.mWebView.getTitle();
    }

    public void setOnPageLoadedListener(WebViewClient.OnPageLoadedListener l) {
        this.mWebViewClient.setOnPageLoadedListener(l);
    }

    public boolean isEnableZoom() {
        return this.enableZoom;
    }

    public void setEnableZoom(boolean enableZoom) {
        this.enableZoom = enableZoom;
        WebSettings webSettings = this.mWebView.getSettings();
        webSettings.setSupportZoom(enableZoom);
        webSettings.setBuiltInZoomControls(enableZoom);
    }

    private class LoadUrlTask
    extends AsyncTask<String, Void, String> {
        String userAgent;

        public LoadUrlTask() {
            this.userAgent = WebFrame.this.getUserAgentString();
        }

        /*
         * Exception decompiling
         */
        protected String doInBackground(String ... urls) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[DOLOOP]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        protected void onPostExecute(String url) {
            if (url == null || url.equals("")) {
                url = "about:blank";
            }
            Log.d("Show URL: " + url);
            WebFrame.this.mWebViewClient.setAllowedUrl(url);
            WebFrame.this.mWebView.loadUrl(url);
            WebFrame.this.requestLayout();
        }
    }
}

