/*
 * Decompiled with CFR 0.152.
 */
package com.adsdk.sdk.mraid;

import com.adsdk.sdk.mraid.MraidCommand;
import com.adsdk.sdk.mraid.MraidCommandClose;
import com.adsdk.sdk.mraid.MraidCommandExpand;
import com.adsdk.sdk.mraid.MraidCommandOpen;
import com.adsdk.sdk.mraid.MraidCommandUseCustomClose;
import com.adsdk.sdk.mraid.MraidView;
import java.util.HashMap;
import java.util.Map;

class MraidCommandRegistry {
    private static Map<String, MraidCommandFactory> commandMap = new HashMap<String, MraidCommandFactory>();

    static {
        commandMap.put("close", new MraidCommandFactory(){

            @Override
            public MraidCommand create(Map<String, String> params, MraidView view) {
                return new MraidCommandClose(params, view);
            }
        });
        commandMap.put("expand", new MraidCommandFactory(){

            @Override
            public MraidCommand create(Map<String, String> params, MraidView view) {
                return new MraidCommandExpand(params, view);
            }
        });
        commandMap.put("usecustomclose", new MraidCommandFactory(){

            @Override
            public MraidCommand create(Map<String, String> params, MraidView view) {
                return new MraidCommandUseCustomClose(params, view);
            }
        });
        commandMap.put("open", new MraidCommandFactory(){

            @Override
            public MraidCommand create(Map<String, String> params, MraidView view) {
                return new MraidCommandOpen(params, view);
            }
        });
    }

    MraidCommandRegistry() {
    }

    static MraidCommand createCommand(String string, Map<String, String> params, MraidView view) {
        MraidCommandFactory factory = commandMap.get(string);
        return factory != null ? factory.create(params, view) : null;
    }

    private static interface MraidCommandFactory {
        public MraidCommand create(Map<String, String> var1, MraidView var2);
    }
}

