/*
 * Decompiled with CFR 0.152.
 */
package com.adsdk.sdk.mraid;

import android.app.Activity;
import android.content.Context;
import android.location.Location;
import android.util.Log;
import com.adsdk.sdk.Ad;
import com.adsdk.sdk.AdListener;
import com.adsdk.sdk.mraid.BaseInterstitialAdapter;
import com.adsdk.sdk.mraid.MoPubView;
import java.util.HashMap;

public class MoPubInterstitial
implements AdListener {
    private MoPubInterstitialView mInterstitialView;
    private BaseInterstitialAdapter mInterstitialAdapter;
    private MoPubInterstitialListener mListener;
    private Activity mActivity;
    private String mAdUnitId;
    private BaseInterstitialAdapter.BaseInterstitialAdapterListener mAdapterListener;
    private DefaultInterstitialAdapterListener mDefaultAdapterListener;
    private InterstitialState mCurrentInterstitialState;

    public MoPubInterstitial(Activity activity, String id) {
        this.mActivity = activity;
        this.mAdUnitId = id;
        this.mInterstitialView = new MoPubInterstitialView((Context)this.mActivity);
        this.mInterstitialView.setAdUnitId(this.mAdUnitId);
        this.mCurrentInterstitialState = InterstitialState.NOT_READY;
        this.mDefaultAdapterListener = new DefaultInterstitialAdapterListener();
        this.mAdapterListener = this.mDefaultAdapterListener;
    }

    public void load() {
        this.invalidateCurrentInterstitial();
        this.mInterstitialView.loadAd();
    }

    public void forceRefresh() {
        this.invalidateCurrentInterstitial();
        this.mInterstitialView.forceRefresh();
    }

    private void invalidateCurrentInterstitial() {
        this.mCurrentInterstitialState = InterstitialState.NOT_READY;
        if (this.mInterstitialAdapter != null) {
            this.mInterstitialAdapter.invalidate();
            this.mInterstitialAdapter = null;
        }
        this.mAdapterListener = this.mDefaultAdapterListener;
        this.mInterstitialView.setAdListener(this);
        this.mInterstitialView.loadAd();
    }

    public boolean isReady() {
        return this.mCurrentInterstitialState == InterstitialState.HTML_AD_READY || this.mCurrentInterstitialState == InterstitialState.NATIVE_AD_READY;
    }

    public boolean show() {
        switch (this.mCurrentInterstitialState) {
            case NATIVE_AD_READY: {
                this.showNativeInterstitial();
                return true;
            }
        }
        return false;
    }

    private void showNativeInterstitial() {
        if (this.mInterstitialAdapter != null) {
            this.mInterstitialAdapter.showInterstitial();
        }
    }

    public void OnAdFailed(MoPubView m) {
        this.mCurrentInterstitialState = InterstitialState.NOT_READY;
        if (this.mListener != null) {
            this.mListener.OnInterstitialFailed();
        }
    }

    public void OnAdLoaded(MoPubView m) {
        this.mCurrentInterstitialState = InterstitialState.HTML_AD_READY;
        if (this.mInterstitialAdapter != null) {
            this.mInterstitialAdapter.invalidate();
            this.mInterstitialAdapter = null;
        }
        if (this.mListener != null) {
            this.mListener.OnInterstitialLoaded();
        }
    }

    public void customEventDidLoadAd() {
    }

    public void customEventDidFailToLoadAd() {
        if (this.mInterstitialView != null) {
            this.mInterstitialView.loadFailUrl();
        }
    }

    public void customEventActionWillBegin() {
        if (this.mInterstitialView != null) {
            this.mInterstitialView.registerClick();
        }
    }

    @Deprecated
    public void showAd() {
        this.mAdapterListener = new DefaultInterstitialAdapterListener(){

            @Override
            public void onNativeInterstitialLoaded(BaseInterstitialAdapter adapter) {
                super.onNativeInterstitialLoaded(adapter);
                MoPubInterstitial.this.show();
            }
        };
        this.mInterstitialView.loadAd();
    }

    public void setKeywords(String keywords) {
        if (this.mInterstitialView != null) {
            this.mInterstitialView.setKeywords(keywords);
        }
    }

    public String getKeywords() {
        return this.mInterstitialView != null ? this.mInterstitialView.getKeywords() : null;
    }

    public Activity getActivity() {
        return this.mActivity;
    }

    public void setListener(MoPubInterstitialListener listener) {
        this.mListener = listener;
    }

    public MoPubInterstitialListener getListener() {
        return this.mListener;
    }

    public Location getLocation() {
        return this.mInterstitialView.getLocation();
    }

    public void destroy() {
        this.mAdapterListener = null;
        if (this.mInterstitialAdapter != null) {
            this.mInterstitialAdapter.invalidate();
            this.mInterstitialAdapter = null;
        }
        this.mInterstitialView.setAdListener(null);
        this.mInterstitialView.destroy();
    }

    public void setLocationAwareness(MoPubView.LocationAwareness awareness) {
        this.mInterstitialView.setLocationAwareness(awareness);
    }

    public MoPubView.LocationAwareness getLocationAwareness() {
        return this.mInterstitialView.getLocationAwareness();
    }

    public void setLocationPrecision(int precision) {
        this.mInterstitialView.setLocationPrecision(precision);
    }

    public int getLocationPrecision() {
        return this.mInterstitialView.getLocationPrecision();
    }

    protected BaseInterstitialAdapter.BaseInterstitialAdapterListener getInterstitialAdapterListener() {
        return this.mAdapterListener;
    }

    @Override
    public void adClicked() {
    }

    @Override
    public void adClosed(Ad ad, boolean completed) {
    }

    @Override
    public void adLoadSucceeded(Ad ad) {
    }

    @Override
    public void adShown(Ad ad, boolean succeeded) {
    }

    @Override
    public void noAdFound() {
    }

    public class DefaultInterstitialAdapterListener
    implements BaseInterstitialAdapter.BaseInterstitialAdapterListener {
        @Override
        public void onNativeInterstitialLoaded(BaseInterstitialAdapter adapter) {
            MoPubInterstitial.this.mCurrentInterstitialState = InterstitialState.NATIVE_AD_READY;
            if (MoPubInterstitial.this.mListener != null) {
                MoPubInterstitial.this.mListener.OnInterstitialLoaded();
            }
        }

        @Override
        public void onNativeInterstitialFailed(BaseInterstitialAdapter adapter) {
            MoPubInterstitial.this.mCurrentInterstitialState = InterstitialState.NOT_READY;
            MoPubInterstitial.this.mInterstitialView.loadFailUrl();
        }

        @Override
        public void onNativeInterstitialClicked(BaseInterstitialAdapter adapter) {
            MoPubInterstitial.this.mInterstitialView.registerClick();
        }

        @Override
        public void onNativeInterstitialExpired(BaseInterstitialAdapter adapter) {
            MoPubInterstitial.this.mCurrentInterstitialState = InterstitialState.NOT_READY;
        }
    }

    private static enum InterstitialState {
        HTML_AD_READY,
        NATIVE_AD_READY,
        NOT_READY;

    }

    public static interface MoPubInterstitialListener {
        public void OnInterstitialLoaded();

        public void OnInterstitialFailed();
    }

    public class MoPubInterstitialView
    extends MoPubView {
        public MoPubInterstitialView(Context context) {
            super(context);
            this.setAutorefreshEnabled(false);
        }

        @Override
        protected void loadNativeSDK(HashMap<String, String> paramsHash) {
            if (paramsHash == null) {
                return;
            }
            MoPubInterstitial interstitial = MoPubInterstitial.this;
            BaseInterstitialAdapter.BaseInterstitialAdapterListener adapterListener = interstitial.getInterstitialAdapterListener();
            String type = paramsHash.get("X-Adtype");
            if (type != null && (type.equals("interstitial") || type.equals("mraid"))) {
                String interstitialType = type.equals("interstitial") ? paramsHash.get("X-Fulladtype") : "mraid";
                Log.i((String)"MoPub", (String)("Loading native adapter for interstitial type: " + interstitialType));
                MoPubInterstitial.this.mInterstitialAdapter = BaseInterstitialAdapter.getAdapterForType(interstitialType);
                if (MoPubInterstitial.this.mInterstitialAdapter != null) {
                    String jsonParams = paramsHash.get("X-Nativeparams");
                    MoPubInterstitial.this.mInterstitialAdapter.init(interstitial, jsonParams);
                    MoPubInterstitial.this.mInterstitialAdapter.setAdapterListener(adapterListener);
                    MoPubInterstitial.this.mInterstitialAdapter.loadInterstitial();
                    return;
                }
            }
            Log.i((String)"MoPub", (String)"Couldn't load native adapter. Trying next ad...");
            adapterListener.onNativeInterstitialFailed(null);
        }
    }
}

