/*
 * Decompiled with CFR 0.152.
 */
package com.adsdk.sdk.mraid;

import android.util.Log;
import com.adsdk.sdk.mraid.MoPubInterstitial;
import java.lang.reflect.Constructor;
import java.util.HashMap;

public abstract class BaseInterstitialAdapter {
    protected boolean mInvalidated;
    protected MoPubInterstitial mInterstitial;
    protected String mJsonParams;
    protected BaseInterstitialAdapterListener mAdapterListener;
    private static final HashMap<String, String> sInterstitialAdapterMap = new HashMap();

    static {
        sInterstitialAdapterMap.put("mraid", "com.adsdk.sdk.mraid.MraidInterstitialAdapter");
        sInterstitialAdapterMap.put("admob_full", "com.adsdk.sdk.mraid.GoogleAdMobInterstitialAdapter");
        sInterstitialAdapterMap.put("millennial_full", "com.adsdk.sdk.mraid.MillennialInterstitialAdapter");
    }

    public abstract void loadInterstitial();

    public abstract void showInterstitial();

    public void init(MoPubInterstitial interstitial, String jsonParams) {
        this.mInterstitial = interstitial;
        this.mJsonParams = jsonParams;
        this.mInvalidated = false;
    }

    public void invalidate() {
        this.mInterstitial = null;
        this.mAdapterListener = null;
        this.mInvalidated = true;
    }

    public boolean isInvalidated() {
        return this.mInvalidated;
    }

    public void setAdapterListener(BaseInterstitialAdapterListener listener) {
        this.mAdapterListener = listener;
    }

    public static BaseInterstitialAdapter getAdapterForType(String type) {
        if (type == null) {
            return null;
        }
        Class<?> adapterClass = BaseInterstitialAdapter.classForAdapterType(type);
        if (adapterClass == null) {
            return null;
        }
        try {
            Constructor<?> constructor = adapterClass.getConstructor(new Class[0]);
            BaseInterstitialAdapter nativeAdapter = (BaseInterstitialAdapter)constructor.newInstance(new Object[0]);
            return nativeAdapter;
        }
        catch (Exception e) {
            Log.d((String)"MoPub", (String)("Couldn't create native interstitial adapter for type: " + type));
            return null;
        }
    }

    private static String classStringForAdapterType(String type) {
        return sInterstitialAdapterMap.get(type);
    }

    private static Class<?> classForAdapterType(String type) {
        String className = BaseInterstitialAdapter.classStringForAdapterType(type);
        if (className == null) {
            Log.d((String)"MoPub", (String)("Couldn't find a handler for this ad type: " + type + "." + " MoPub for Android does not support it at this time."));
            return null;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            Log.d((String)"MoPub", (String)("Couldn't find " + className + "class." + " Make sure the project includes the adapter library for " + className + " from the extras folder"));
            return null;
        }
    }

    public static interface BaseInterstitialAdapterListener {
        public void onNativeInterstitialLoaded(BaseInterstitialAdapter var1);

        public void onNativeInterstitialFailed(BaseInterstitialAdapter var1);

        public void onNativeInterstitialClicked(BaseInterstitialAdapter var1);

        public void onNativeInterstitialExpired(BaseInterstitialAdapter var1);
    }
}

