/*
 * Decompiled with CFR 0.152.
 */
package com.adsdk.sdk.mraid;

import android.util.Log;
import com.adsdk.sdk.mraid.MoPubView;
import java.lang.reflect.Constructor;
import java.util.HashMap;

public abstract class BaseAdapter {
    protected boolean mInvalidated;
    protected MoPubView mMoPubView;
    protected String mJsonParams;
    private static final HashMap<String, String> sAdapterMap = new HashMap();

    static {
        sAdapterMap.put("admob_native", "com.adsdk.sdk.mraid.GoogleAdMobAdapter");
        sAdapterMap.put("millennial_native", "com.adsdk.sdk.mraid.MillennialAdapter");
        sAdapterMap.put("mraid", "com.adsdk.sdk.mraid.MraidAdapter");
    }

    public abstract void loadAd();

    public void init(MoPubView view, String jsonParams) {
        this.mMoPubView = view;
        this.mJsonParams = jsonParams;
        this.mInvalidated = false;
    }

    public void invalidate() {
        this.mMoPubView = null;
        this.mInvalidated = true;
    }

    public boolean isInvalidated() {
        return this.mInvalidated;
    }

    public static BaseAdapter getAdapterForType(String type) {
        if (type == null) {
            return null;
        }
        Class<?> adapterClass = BaseAdapter.classForAdapterType(type);
        if (adapterClass == null) {
            return null;
        }
        try {
            Constructor<?> constructor = adapterClass.getConstructor(new Class[0]);
            BaseAdapter nativeAdapter = (BaseAdapter)constructor.newInstance(new Object[0]);
            return nativeAdapter;
        }
        catch (Exception e) {
            Log.d((String)"MoPub", (String)("Couldn't create native adapter for type: " + type));
            return null;
        }
    }

    private static String classStringForAdapterType(String type) {
        return sAdapterMap.get(type);
    }

    private static Class<?> classForAdapterType(String type) {
        String className = BaseAdapter.classStringForAdapterType(type);
        if (className == null) {
            Log.d((String)"MoPub", (String)("Couldn't find a handler for this ad type: " + type + "." + " MoPub for Android does not support it at this time."));
            return null;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            Log.d((String)"MoPub", (String)("Couldn't find " + className + " class." + " Make sure the project includes the adapter library for " + className + " from the extras folder"));
            return null;
        }
    }
}

