/*
 * Decompiled with CFR 0.152.
 */
package com.adsdk.sdk.banner;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.Location;
import android.location.LocationManager;
import android.os.Handler;
import android.telephony.TelephonyManager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.adsdk.sdk.AdListener;
import com.adsdk.sdk.AdRequest;
import com.adsdk.sdk.BannerAd;
import com.adsdk.sdk.Log;
import com.adsdk.sdk.RequestBannerAd;
import com.adsdk.sdk.Util;
import com.adsdk.sdk.banner.BannerAdView;
import com.adsdk.sdk.banner.ReloadTask;
import com.adsdk.sdk.mraid.MoPubView;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;

public class AdView
extends FrameLayout {
    public static final int LIVE = 0;
    public static final int TEST = 1;
    private boolean includeLocation = false;
    private String publisherId;
    private boolean animation;
    private MoPubView mMoPubview;
    private BannerAdView mBannerView;
    private Timer reloadTimer;
    private boolean isInternalBrowser = false;
    private BannerAd response;
    private AdRequest request;
    private String requestURL = null;
    private LocationManager locationManager;
    private int isAccessFineLocation;
    private int isAccessCoarseLocation;
    private int telephonyPermission;
    private BroadcastReceiver mScreenStateReceiver;
    private Context mContext = null;
    protected boolean mIsInForeground;
    private AdListener adListener;
    private Thread loadContentThread;
    private InputStream xml;
    private final Handler updateHandler = new Handler();
    private final Runnable showContent = new Runnable(){

        @Override
        public void run() {
            AdView.this.showContent();
        }
    };
    private String mUserAgent;

    public void setWidth(int width) {
    }

    public void setHeight(int width) {
    }

    public AdView(Context context, AttributeSet attributes) {
        super(context, attributes);
        this.mContext = context;
        if (attributes != null) {
            int count = attributes.getAttributeCount();
            int i = 0;
            while (i < count) {
                String name = attributes.getAttributeName(i);
                if (name.equals("publisherId")) {
                    this.publisherId = attributes.getAttributeValue(i);
                } else if (name.equals("request_url")) {
                    this.requestURL = attributes.getAttributeValue(i);
                } else if (name.equals("animation")) {
                    this.animation = attributes.getAttributeBooleanValue(i, false);
                } else if (name.equals("includeLocation")) {
                    this.includeLocation = attributes.getAttributeBooleanValue(i, false);
                }
                ++i;
            }
        }
        this.initialize(context);
    }

    public AdView(Context context, String requestURL, String publisherId) {
        this(context, requestURL, publisherId, false, false);
    }

    public AdView(Context context, String requestURL, InputStream xml, String publisherId, boolean includeLocation, boolean animation) {
        this(context, xml, requestURL, publisherId, includeLocation, animation);
    }

    public AdView(Context context, InputStream xml, String requestURL, String publisherId, boolean includeLocation, boolean animation) {
        super(context);
        this.xml = xml;
        this.requestURL = requestURL;
        this.mContext = context;
        this.publisherId = publisherId;
        this.includeLocation = includeLocation;
        this.animation = animation;
        this.initialize(context);
    }

    public AdView(Context context, String requestURL, String publisherId, boolean includeLocation, boolean animation) {
        this(context, requestURL, publisherId, includeLocation, animation, null);
    }

    public AdView(Context context, String requestURL, String publisherId, boolean includeLocation, boolean animation, AdListener listener) {
        super(context);
        this.requestURL = requestURL;
        this.mContext = context;
        this.publisherId = publisherId;
        this.includeLocation = includeLocation;
        this.animation = animation;
        this.adListener = listener;
        Log.d("AdListener: " + (this.adListener == null));
        this.initialize(context);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        IntentFilter filter = new IntentFilter("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.USER_PRESENT");
        this.mContext.registerReceiver(this.mScreenStateReceiver, filter);
        Log.v("ADSDK", "onAttachedToWindow");
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.unregisterScreenStateBroadcastReceiver();
        Log.v("ADSDK", "onDetachedFromWindow");
    }

    private Location getLocation() {
        if (this.locationManager != null) {
            boolean isNetworkEnabled;
            boolean isGpsEnabled;
            if (this.isAccessFineLocation == 0 && (isGpsEnabled = this.locationManager.isProviderEnabled("gps"))) {
                return this.locationManager.getLastKnownLocation("gps");
            }
            if (this.isAccessCoarseLocation == 0 && (isNetworkEnabled = this.locationManager.isProviderEnabled("network"))) {
                return this.locationManager.getLastKnownLocation("network");
            }
        }
        return null;
    }

    public int getRefreshRate() {
        if (this.response != null) {
            return this.response.getRefresh();
        }
        return -1;
    }

    private AdRequest getRequest() {
        if (this.request == null) {
            this.request = new AdRequest();
            if (this.telephonyPermission == 0) {
                TelephonyManager tm = (TelephonyManager)this.getContext().getSystemService("phone");
                this.request.setDeviceId(tm.getDeviceId());
            } else {
                this.request.setDeviceId(Util.getDeviceId(this.mContext));
            }
            this.request.setPublisherId(this.publisherId);
            this.request.setUserAgent(this.mUserAgent);
            this.request.setUserAgent2(Util.buildUserAgent());
            Log.d("ADSDK", "WebKit UserAgent:" + this.request.getUserAgent());
            Log.d("ADSDK", "SDK built UserAgent:" + this.request.getUserAgent2());
        }
        Location location = null;
        if (this.includeLocation) {
            location = this.getLocation();
        }
        if (location != null) {
            Log.d("ADSDK", "location is longitude: " + location.getLongitude() + ", latitude: " + location.getLatitude());
            this.request.setLatitude(location.getLatitude());
            this.request.setLongitude(location.getLongitude());
        } else {
            this.request.setLatitude(0.0);
            this.request.setLongitude(0.0);
        }
        this.request.setType(0);
        this.request.setRequestURL(this.requestURL);
        return this.request;
    }

    private void initialize(Context context) {
        this.mUserAgent = Util.getDefaultUserAgentString(this.getContext());
        Log.LOGGING_ENABLED = Log.isLoggingEnabled(this.mContext);
        Log.d("ADSDK", "SDK Version:4.1.6");
        this.registerScreenStateBroadcastReceiver();
        this.locationManager = null;
        this.telephonyPermission = context.checkCallingOrSelfPermission("android.permission.READ_PHONE_STATE");
        this.isAccessFineLocation = context.checkCallingOrSelfPermission("android.permission.ACCESS_FINE_LOCATION");
        this.isAccessCoarseLocation = context.checkCallingOrSelfPermission("android.permission.ACCESS_COARSE_LOCATION");
        if (this.isAccessFineLocation == 0 || this.isAccessCoarseLocation == 0) {
            this.locationManager = (LocationManager)this.getContext().getSystemService("location");
        }
    }

    public boolean isInternalBrowser() {
        return this.isInternalBrowser;
    }

    private void registerScreenStateBroadcastReceiver() {
        this.mScreenStateReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("android.intent.action.SCREEN_OFF")) {
                    if (AdView.this.mIsInForeground) {
                        Log.d("ADSDK", "Screen sleep with ad in foreground, disable refresh");
                        AdView.this.pause();
                    } else {
                        Log.d("ADSDK", "Screen sleep but ad in background; refresh should already be disabled");
                    }
                } else if (intent.getAction().equals("android.intent.action.USER_PRESENT")) {
                    if (AdView.this.mIsInForeground) {
                        AdView.this.resume();
                        Log.d("ADSDK", "Screen wake / ad in foreground, reset refresh");
                    } else {
                        Log.d("ADSDK", "Screen wake but ad in background; don't enable refresh");
                    }
                }
            }
        };
        IntentFilter filter = new IntentFilter("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.USER_PRESENT");
        this.mContext.registerReceiver(this.mScreenStateReceiver, filter);
    }

    private void loadContent() {
        Log.d("ADSDK", "load content");
        if (this.loadContentThread == null) {
            this.loadContentThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    Log.d("ADSDK", "starting request thread");
                    RequestBannerAd requestAd = AdView.this.xml == null ? new RequestBannerAd() : new RequestBannerAd(AdView.this.xml);
                    try {
                        AdView.this.response = (BannerAd)requestAd.sendRequest(AdView.this.getRequest());
                        if (AdView.this.response != null) {
                            Log.d("ADSDK", "response received");
                            Log.d("ADSDK", "getVisibility: " + AdView.this.getVisibility());
                            AdView.this.updateHandler.post(AdView.this.showContent);
                        }
                    }
                    catch (Throwable e) {
                        AdView.this.notifyLoadAdFailed(e);
                    }
                    AdView.this.loadContentThread = null;
                    Log.d("ADSDK", "finishing request thread");
                }
            });
            this.loadContentThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable ex) {
                    Log.e("ADSDK", "Exception in request thread", ex);
                    AdView.this.loadContentThread = null;
                }
            });
            this.loadContentThread.start();
        }
    }

    public void loadNextAd() {
        Log.d("ADSDK", "load next ad");
        this.loadContent();
    }

    private void notifyNoAd() {
        this.updateHandler.post(new Runnable(){

            @Override
            public void run() {
                Log.d("ADSDK", "No Ad");
                if (AdView.this.adListener != null) {
                    AdView.this.adListener.noAdFound();
                }
            }
        });
    }

    private void notifyLoadAdFailed(final Throwable e) {
        this.updateHandler.post(new Runnable(){

            @Override
            public void run() {
                Log.e("ADSDK", "Exception in request thread", e);
                if (AdView.this.adListener != null) {
                    Log.d("ADSDK", "notify bannerListener: " + AdView.this.adListener.getClass().getName());
                    AdView.this.adListener.noAdFound();
                }
            }
        });
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (visibility == 0) {
            this.mIsInForeground = true;
            this.resume();
        } else {
            this.mIsInForeground = false;
            this.pause();
        }
        Log.d("ADSDK", "onWindowVisibilityChanged: " + visibility);
    }

    public void pause() {
        if (this.reloadTimer != null) {
            try {
                Log.d("ADSDK", "cancel reload timer");
                this.reloadTimer.cancel();
                this.reloadTimer = null;
            }
            catch (Exception e) {
                Log.e("ADSDK", "unable to cancel reloadTimer", e);
            }
        }
    }

    private void showContent() {
        if (this.mMoPubview != null) {
            this.mMoPubview.destroy();
            this.removeView((View)this.mMoPubview);
        }
        if (this.mBannerView != null) {
            this.removeView((View)this.mBannerView);
        }
        if (this.response.getType() == 1 || this.response.getType() == 0) {
            this.mBannerView = new BannerAdView(this.mContext, this.response, this.animation, this.adListener);
            this.addView((View)this.mBannerView);
        }
        if (this.response.getType() == 7) {
            this.mMoPubview = new MoPubView(this.mContext);
            float scale = this.mContext.getResources().getDisplayMetrics().density;
            this.addView((View)this.mMoPubview, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, (int)(50.0f * scale + 0.5f)));
            com.adsdk.sdk.mraid.AdView m = new com.adsdk.sdk.mraid.AdView(this.mContext, this.mMoPubview, this.response);
            this.mMoPubview.setAdListener(this.adListener);
            m.setAdUnitId("");
            m.loadAd();
        }
        if (this.response.getType() == 2) {
            this.notifyNoAd();
        }
        this.startReloadTimer();
    }

    public void release() {
        this.unregisterScreenStateBroadcastReceiver();
        if (this.mMoPubview != null) {
            this.mMoPubview.destroy();
        }
    }

    private void unregisterScreenStateBroadcastReceiver() {
        try {
            this.mContext.unregisterReceiver(this.mScreenStateReceiver);
        }
        catch (Exception IllegalArgumentException2) {
            Log.d("Failed to unregister screen state broadcast receiver (never registered).");
        }
    }

    public void resume() {
        if (this.reloadTimer != null) {
            this.reloadTimer.cancel();
            this.reloadTimer = null;
        }
        this.reloadTimer = new Timer();
        Log.d("ADSDK", "response: " + this.response);
        if (this.response != null && this.response.getRefresh() > 0) {
            this.startReloadTimer();
        } else if (this.response == null || this.mMoPubview == null && this.mBannerView == null) {
            this.loadContent();
        }
    }

    public void setAdListener(AdListener bannerListener) {
        this.adListener = bannerListener;
        if (this.mMoPubview != null) {
            this.mMoPubview.setAdListener(bannerListener);
        }
        if (this.mBannerView != null) {
            this.mBannerView.setAdListener(bannerListener);
        }
    }

    public void setInternalBrowser(boolean isInternalBrowser) {
        this.isInternalBrowser = isInternalBrowser;
    }

    private void startReloadTimer() {
        Log.d("ADSDK", "start reload timer");
        if (this.reloadTimer == null || this.response.getRefresh() <= 0) {
            return;
        }
        int refreshTime = this.response.getRefresh() * 1000;
        Log.d("ADSDK", "set timer: " + refreshTime);
        ReloadTask reloadTask = new ReloadTask(this);
        this.reloadTimer.schedule((TimerTask)reloadTask, refreshTime);
    }
}

