/*
 * Decompiled with CFR 0.152.
 */
package com.adsdk.sdk;

import com.adsdk.sdk.BannerAd;
import com.adsdk.sdk.Log;
import com.adsdk.sdk.RequestAd;
import com.adsdk.sdk.RequestException;
import com.adsdk.sdk.data.ClickType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.Scanner;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RequestBannerAd
extends RequestAd<BannerAd> {
    public RequestBannerAd() {
    }

    public RequestBannerAd(InputStream xmlArg) {
        this.is = xmlArg;
        Log.d("Parse is null" + (this.is == null));
    }

    private int getInteger(String text) {
        if (text == null) {
            return 0;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private String getAttribute(Document document, String elementName, String attributeName) {
        String attribute;
        NodeList nodeList = document.getElementsByTagName(elementName);
        Element element = (Element)nodeList.item(0);
        if (element != null && (attribute = element.getAttribute(attributeName)).length() != 0) {
            return attribute;
        }
        return null;
    }

    private String getValue(Document document, String name) {
        NodeList nodeList = document.getElementsByTagName(name);
        Element element = (Element)nodeList.item(0);
        if (element != null && (nodeList = element.getChildNodes()).getLength() > 0) {
            return nodeList.item(0).getNodeValue();
        }
        return null;
    }

    private boolean getValueAsBoolean(Document document, String name) {
        return "yes".equalsIgnoreCase(this.getValue(document, name));
    }

    private int getValueAsInt(Document document, String name) {
        return this.getInteger(this.getValue(document, name));
    }

    private String convertStreamToString(InputStream is) {
        try {
            return new Scanner(is).useDelimiter("\\A").next();
        }
        catch (NoSuchElementException e) {
            return "";
        }
    }

    @Override
    BannerAd parse(InputStream inputStream) throws RequestException {
        BannerAd response;
        block14: {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            response = new BannerAd();
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                InputSource src = new InputSource(inputStream);
                if (Log.LOGGING_ENABLED) {
                    String sResponse = this.convertStreamToString(inputStream);
                    Log.d("Ad RequestPerform HTTP Response: " + sResponse);
                    byte[] bytes = sResponse.getBytes("ISO-8859-1");
                    src = new InputSource(new ByteArrayInputStream(bytes));
                }
                src.setEncoding("ISO-8859-1");
                Document doc = db.parse(src);
                Element element = doc.getDocumentElement();
                if (element == null) {
                    throw new RequestException("Cannot parse Response, document is not an xml");
                }
                String errorValue = this.getValue(doc, "error");
                if (errorValue != null) {
                    throw new RequestException("Error Response received: " + errorValue);
                }
                String type = element.getAttribute("type");
                element.normalize();
                if ("imageAd".equalsIgnoreCase(type)) {
                    response.setType(0);
                    response.setBannerWidth(this.getValueAsInt(doc, "bannerwidth"));
                    response.setBannerHeight(this.getValueAsInt(doc, "bannerheight"));
                    ClickType clickType = ClickType.getValue(this.getValue(doc, "clicktype"));
                    response.setClickType(clickType);
                    response.setClickUrl(this.getValue(doc, "clickurl"));
                    response.setImageUrl(this.getValue(doc, "imageurl"));
                    response.setRefresh(this.getValueAsInt(doc, "refresh"));
                    response.setScale(this.getValueAsBoolean(doc, "scale"));
                    response.setSkipPreflight(this.getValueAsBoolean(doc, "skippreflight"));
                    break block14;
                }
                if ("textAd".equalsIgnoreCase(type)) {
                    response.setType(1);
                    response.setText(this.getValue(doc, "htmlString"));
                    String skipOverlay = this.getAttribute(doc, "htmlString", "skipoverlaybutton");
                    Log.i("PARSER", "SkipOverlay: " + skipOverlay);
                    if (skipOverlay != null) {
                        response.setSkipOverlay(Integer.parseInt(skipOverlay));
                    }
                    ClickType clickType = ClickType.getValue(this.getValue(doc, "clicktype"));
                    response.setClickType(clickType);
                    response.setClickUrl(this.getValue(doc, "clickurl"));
                    response.setRefresh(this.getValueAsInt(doc, "refresh"));
                    response.setScale(this.getValueAsBoolean(doc, "scale"));
                    response.setSkipPreflight(this.getValueAsBoolean(doc, "skippreflight"));
                    break block14;
                }
                if ("mraidAd".equalsIgnoreCase(type)) {
                    response.setType(7);
                    response.setText(this.getValue(doc, "htmlString"));
                    String skipOverlay = this.getAttribute(doc, "htmlString", "skipoverlaybutton");
                    Log.i("PARSER", "SkipOverlay: " + skipOverlay);
                    if (skipOverlay != null) {
                        response.setSkipOverlay(Integer.parseInt(skipOverlay));
                    }
                    ClickType clickType = ClickType.getValue(this.getValue(doc, "clicktype"));
                    response.setClickType(clickType);
                    response.setClickUrl(this.getValue(doc, "clickurl"));
                    response.setUrlType(this.getValue(doc, "urltype"));
                    response.setRefresh(0);
                    response.setScale(this.getValueAsBoolean(doc, "scale"));
                    response.setSkipPreflight(this.getValueAsBoolean(doc, "skippreflight"));
                    break block14;
                }
                if ("noAd".equalsIgnoreCase(type)) {
                    response.setType(2);
                    break block14;
                }
                throw new RequestException("Unknown response type " + type);
            }
            catch (ParserConfigurationException e) {
                throw new RequestException("Cannot parse Response", e);
            }
            catch (SAXException e) {
                throw new RequestException("Cannot parse Response", e);
            }
            catch (IOException e) {
                throw new RequestException("Cannot read Response", e);
            }
            catch (Throwable t) {
                throw new RequestException("Cannot read Response", t);
            }
        }
        return response;
    }

    @Override
    BannerAd parseTestString() throws RequestException {
        return this.parse(this.is);
    }
}

